/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

abstract class ServiceRecord
implements IServiceRecord {
    private static final String UNKNOWN_PROPERTY_KEY = "ServiceRecord.UnknownProperty";
    private static final String UNKNOWN_SERVICE_EVENT_KEY = "ServiceRecord.UnknownServiceEvent";
    protected static final String[] NO_PROPERTY_KEYS = new String[0];
    private BundleContext bundleContext;
    private Object service;
    private ServiceListener serviceListener;
    private final Object lock = new Object();

    protected ServiceRecord(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
        this.setService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object basicGetService() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return this.service;
        }
    }

    public final String basicToString() {
        String value = super.toString();
        return value;
    }

    protected abstract String createServiceFilter();

    protected final void createServiceFilterOn(StringBuffer buffer, String name) {
        buffer.append('(');
        buffer.append("objectClass");
        buffer.append('=');
        buffer.append(name);
        buffer.append(')');
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ServiceRecord.this.serviceChanged(event);
            }
        };
    }

    protected int estimateToStringBufferSize() {
        return 100;
    }

    protected final Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = null;
        try {
            bundle = bundleContext.getBundle();
        }
        catch (IllegalStateException illegalStateException) {}
        return bundle;
    }

    public final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private long getId() {
        Long wrapper = (Long)this.getProperty("service.id");
        long id = wrapper;
        return id;
    }

    protected final Object getLock() {
        return this.lock;
    }

    public Object getProperty(String key) {
        Assertion.checkArgumentIsNotNull(key, "key");
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        Object property = serviceReference.getProperty(key);
        if (property == null) {
            this.signalUnknownProperty(key);
        }
        return property;
    }

    public String[] getPropertyKeys() {
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return NO_PROPERTY_KEYS;
        }
        String[] keys = serviceReference.getPropertyKeys();
        return keys;
    }

    public Object getService() {
        Object service = this.basicGetService();
        return service;
    }

    private ServiceListener getServiceListener() {
        return this.serviceListener;
    }

    protected abstract ServiceReference getServiceReference();

    protected void handleInvalidSyntaxException(InvalidSyntaxException exception) {
        exception.printStackTrace();
        String message = exception.getMessage();
        LogUtility.logError(message);
    }

    protected void handleModifiedService(ServiceReference serviceReference) {
    }

    protected void handleRegisteredService(ServiceReference serviceReference) {
    }

    private void handleUnknownServiceEvent(ServiceEvent event) {
        String pattern = Messages.getString(UNKNOWN_SERVICE_EVENT_KEY);
        String message = MessageFormatter.format(pattern, event);
        LogUtility.logError(message);
    }

    protected void handleUnregisteringService(ServiceReference serviceReference) {
    }

    private boolean hasServiceReference() {
        ServiceReference reference = this.getServiceReference();
        boolean result = reference != null;
        return result;
    }

    protected final boolean isRegisteredForServiceEvents() {
        ServiceListener listener = this.getServiceListener();
        boolean registered = listener != null;
        return registered;
    }

    private void printIdOn(StringBuffer buffer) {
        buffer.append(", id=");
        if (this.hasServiceReference()) {
            long id = this.getId();
            buffer.append(id);
        } else {
            buffer.append("<none>");
        }
    }

    protected void printOn(StringBuffer buffer) {
        this.printIdOn(buffer);
        this.printServiceOn(buffer);
    }

    protected final void printOn(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append(object);
        } else {
            Class<?> clazz = object.getClass();
            String name = clazz.getName();
            int hashCode = object.hashCode();
            String hexHashCode = Integer.toHexString(hashCode);
            buffer.append(name);
            buffer.append('@');
            buffer.append(hexHashCode);
        }
    }

    protected final void printServiceOn(StringBuffer buffer) {
        buffer.append(", service=");
        Object service = this.getService();
        this.printOn(buffer, service);
    }

    protected final void registerAsServiceListener() {
        boolean registered = this.isRegisteredForServiceEvents();
        if (registered) {
            return;
        }
        ServiceListener listener = this.createServiceListener();
        this.setServiceListener(listener);
        BundleContext bundleContext = this.getBundleContext();
        String filter = this.createServiceFilter();
        try {
            bundleContext.addServiceListener(listener, filter);
        }
        catch (InvalidSyntaxException exception) {
            this.handleInvalidSyntaxException(exception);
        }
    }

    private void serviceChanged(ServiceEvent event) {
        boolean match;
        ServiceReference serviceReference = this.getServiceReference();
        ServiceReference changedServiceReference = event.getServiceReference();
        if (serviceReference != null && !(match = changedServiceReference.equals(serviceReference))) {
            return;
        }
        int type = event.getType();
        switch (type) {
            case 2: {
                this.handleModifiedService(changedServiceReference);
                break;
            }
            case 1: {
                this.handleRegisteredService(changedServiceReference);
                break;
            }
            case 4: {
                this.handleUnregisteringService(changedServiceReference);
                break;
            }
            default: {
                this.handleUnknownServiceEvent(event);
            }
        }
    }

    private final void setBundleContext(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setService(Object service) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.service = service;
        }
    }

    private void setServiceListener(ServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    protected final void signalUnknownProperty(String key) {
        String pattern = Messages.getString(UNKNOWN_PROPERTY_KEY);
        String message = MessageFormatter.format(pattern, key);
        throw new IllegalArgumentException(message);
    }

    public final String toString() {
        int size = this.estimateToStringBufferSize();
        StringBuffer buffer = new StringBuffer(size);
        String value = this.basicToString();
        buffer.append((Object)value);
        this.printOn(buffer);
        String description = buffer.toString();
        return description;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void unregisterAsServiceListener() {
        boolean registered = this.isRegisteredForServiceEvents();
        if (!registered) {
            return;
        }
        BundleContext bundleContext = this.getBundleContext();
        ServiceListener listener = this.getServiceListener();
        try {
            try {
                bundleContext.removeServiceListener(listener);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setServiceListener(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.setServiceListener(null);
            return;
        }
    }
}

