/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

class FrameworkManager {
    private static final String FRAMEWORK_ERROR_HAS_OCCURRED_KEY = "FrameworkManager.FrameworkErrorOccurred";
    private static final String FREE_MEMORY_AFTER_GC_KEY = "FrameworkManager.FreeMemoryAfterGc";
    private static final String FREE_MEMORY_BEFORE_GC_KEY = "FrameworkManager.FreeMemoryBeforeGc";
    private static final String FREE_MEMORY_DELTA_KEY = "FrameworkManager.FreeMemoryDelta";
    private static final String TOTAL_MEMORY_KEY = "FrameworkManager.TotalMemory";
    private static final String UNKNOWN_BUNDLE_CONTEXT_KEY = "Common.UnknownBundleContext";
    private static final String UNKNOWN_FRAMEWORK_EVENT_KEY = "FrameworkManager.UnknownFrameworkEvent";
    private static final FrameworkManager INSTANCE = new FrameworkManager();
    private BundleContext bundleContext;
    private FrameworkListener frameworkListener;

    static FrameworkManager getInstance() {
        return INSTANCE;
    }

    private FrameworkManager() {
        this.setFrameworkListener(this.createFrameworkListener());
    }

    private void checkShutdownIsAllowed(BundleContext bundleContext) {
        BundleContext bc = this.getBundleContext();
        if (bundleContext.equals(bc)) {
            return;
        }
        String message = Messages.getString(UNKNOWN_BUNDLE_CONTEXT_KEY);
        throw new IllegalArgumentException(message);
    }

    private FrameworkListener createFrameworkListener() {
        return new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                FrameworkManager.this.frameworkEvent(event);
            }
        };
    }

    private void frameworkEvent(FrameworkEvent event) {
        int type = event.getType();
        switch (type) {
            case 1: {
                this.handleFrameworkStarted(event);
                break;
            }
            case 2: {
                this.handleFrameworkError(event);
                break;
            }
            case 4: {
                this.handleFrameworkPackagesRefreshed(event);
                break;
            }
            case 8: {
                this.handleFrameworkStartLevelChanged(event);
                break;
            }
            case 16: {
                this.handleFrameworkWarning(event);
                break;
            }
            case 32: {
                this.handleFrameworkInfo(event);
                break;
            }
            default: {
                this.handleUnknownFrameworkEvent(event);
            }
        }
    }

    private void gc() {
        System.gc();
        System.gc();
        System.runFinalization();
        System.gc();
        System.gc();
    }

    protected final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private FrameworkListener getFrameworkListener() {
        return this.frameworkListener;
    }

    protected void handleFrameworkError(FrameworkEvent event) {
        this.logFrameworkError(event);
    }

    protected void handleFrameworkInfo(FrameworkEvent event) {
    }

    protected void handleFrameworkPackagesRefreshed(FrameworkEvent event) {
    }

    protected void handleFrameworkStarted(FrameworkEvent event) {
        this.logMemoryStatistics();
    }

    protected void handleFrameworkStartLevelChanged(FrameworkEvent event) {
    }

    protected void handleFrameworkWarning(FrameworkEvent event) {
    }

    protected void handleUnknownFrameworkEvent(FrameworkEvent event) {
        this.logUnknownFrameworkEvent(event);
    }

    private void hookupFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        FrameworkListener listener = this.getFrameworkListener();
        bundleContext.addFrameworkListener(listener);
    }

    public final boolean isStarted() {
        BundleContext bundleContext = this.getBundleContext();
        boolean started = bundleContext != null;
        return started;
    }

    private void logDebug(String message) {
        LogUtility.logDebug(this, message);
    }

    private void logError(String message) {
        LogUtility.logError(this, message);
    }

    private void logError(String message, Throwable throwable) {
        LogUtility.logError(this, message, throwable);
    }

    protected final void logFrameworkError(FrameworkEvent event) {
        Throwable throwable = event.getThrowable();
        String message = Messages.getString(FRAMEWORK_ERROR_HAS_OCCURRED_KEY);
        this.logError(message, throwable);
    }

    protected final void logMemoryStatistics() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long before = runtime.freeMemory();
        this.gc();
        long after = runtime.freeMemory();
        long delta = after - before;
        this.logMemoryStatistics(total, before, after, delta);
    }

    private void logMemoryStatistics(long total, long before, long after, long delta) {
        String pattern = Messages.getString(TOTAL_MEMORY_KEY);
        Long wrapper = new Long(total);
        String message = MessageFormatter.format(pattern, wrapper);
        this.logDebug(message);
        pattern = Messages.getString(FREE_MEMORY_BEFORE_GC_KEY);
        wrapper = new Long(before);
        message = MessageFormatter.format(pattern, wrapper);
        this.logDebug(message);
        pattern = Messages.getString(FREE_MEMORY_AFTER_GC_KEY);
        wrapper = new Long(after);
        message = MessageFormatter.format(pattern, wrapper);
        this.logDebug(message);
        pattern = Messages.getString(FREE_MEMORY_DELTA_KEY);
        wrapper = new Long(delta);
        message = MessageFormatter.format(pattern, wrapper);
        this.logDebug(message);
    }

    protected final void logUnknownFrameworkEvent(FrameworkEvent event) {
        String pattern = Messages.getString(UNKNOWN_FRAMEWORK_EVENT_KEY);
        Object[] values = new Object[2];
        Class<?> clazz = this.getClass();
        String name = clazz.getName();
        values[0] = name;
        values[1] = event;
        String message = MessageFormatter.format(pattern, values);
        this.logError(message);
    }

    private void setBundleContext(BundleContext bundleContext) {
        if (this.bundleContext != null) {
            this.unhookFrameworkListener();
        }
        this.bundleContext = bundleContext;
        if (this.bundleContext != null) {
            this.hookupFrameworkListener();
        }
    }

    private void setFrameworkListener(FrameworkListener frameworkListener) {
        this.frameworkListener = frameworkListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        FrameworkManager frameworkManager = this;
        synchronized (frameworkManager) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.checkShutdownIsAllowed(bundleContext);
            this.setBundleContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startup(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        FrameworkManager frameworkManager = this;
        synchronized (frameworkManager) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(bundleContext);
        }
    }

    private void unhookFrameworkListener() {
        BundleContext bundleContext = this.getBundleContext();
        FrameworkListener listener = this.getFrameworkListener();
        bundleContext.removeFrameworkListener(listener);
    }
}

