/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MiscUtility;

public final class WarningMessageUtility {
    private static final String BUNDLE_WARNING_MESSAGE_1_KEY = "WarningMessageUtility.BundleWarningMessage1";
    private static final String BUNDLE_WARNING_MESSAGE_2_KEY = "WarningMessageUtility.BundleWarningMessage2";
    private static final String WARNING_FILE_KEY = "org.eclipse.soda.sat.core.warning.file";
    private static final String WARNING_MESSAGE_KEY = "WarningMessageUtility.WarningMessage";
    private static final String WARNING_STATUS_KEY = "org.eclipse.soda.sat.core.warning.status";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final WarningMessageUtility INSTANCE = new WarningMessageUtility();
    private boolean on;
    private OutputStream outputStream;

    public static WarningMessageUtility getInstance() {
        return INSTANCE;
    }

    private WarningMessageUtility() {
        this.setOn(this.getInitialState());
        this.setOutputStream(this.getInitialOutputStream());
    }

    private FileOutputStream createFileOutputStream(String filename, boolean append) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename, append);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return stream;
    }

    private String createWarningMessage(String issuer, Object source, String warning, String label, String message) {
        String pattern;
        Object[] objectArray = new Object[5];
        objectArray[0] = issuer;
        objectArray[1] = warning;
        objectArray[2] = label;
        objectArray[3] = message;
        Object[] values = objectArray;
        if (source == null) {
            pattern = Messages.getString(WARNING_MESSAGE_KEY);
        } else {
            pattern = label == null && message == null ? Messages.getString(BUNDLE_WARNING_MESSAGE_1_KEY) : Messages.getString(BUNDLE_WARNING_MESSAGE_2_KEY);
            values[4] = source;
        }
        String text = MessageFormatter.format(pattern, values);
        return text;
    }

    private OutputStream getConsoleOutputStream() {
        return System.err;
    }

    private OutputStream getInitialOutputStream() {
        OutputStream stream = null;
        String filename = System.getProperty(WARNING_FILE_KEY);
        if (filename == null) {
            stream = this.getConsoleOutputStream();
        } else {
            stream = this.createFileOutputStream(filename, false);
            if (stream == null) {
                stream = this.getConsoleOutputStream();
            }
        }
        return stream;
    }

    private boolean getInitialState() {
        MiscUtility utility = MiscUtility.getInstance();
        boolean state = utility.getBooleanProperty(WARNING_STATUS_KEY, true);
        return state;
    }

    private OutputStream getOutputStream() {
        return this.outputStream;
    }

    private boolean isDebugging() {
        int level = LogUtility.getLoggingLevel();
        boolean debugging = level == 4;
        return debugging;
    }

    public boolean isOn() {
        return this.on;
    }

    public void sendOutputToConsole() {
        OutputStream stream = this.getConsoleOutputStream();
        this.setOutputStream(stream);
    }

    public void sendOutputToFile(String filename) {
        FileOutputStream stream = this.createFileOutputStream(filename, true);
        this.setOutputStream(stream);
    }

    private void setOn(boolean on) {
        this.on = on;
    }

    private void setOutputStream(OutputStream outputStream) {
        if (this.outputStream instanceof FileOutputStream) {
            try {
                this.outputStream.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.outputStream = outputStream;
    }

    public void turnOff() {
        this.setOn(false);
    }

    public void turnOn() {
        this.setOn(true);
    }

    public void warn(String issuer, Object source, String warning, String label, String message) {
        boolean on = this.isOn();
        if (!on) {
            return;
        }
        boolean debugging = this.isDebugging();
        if (!debugging) {
            return;
        }
        String text = this.createWarningMessage(issuer, source, warning, label, message);
        this.write(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String message) {
        byte[] data = message.getBytes();
        OutputStream stream = this.getOutputStream();
        byte[] lineSeparatorBytes = LINE_SEPARATOR.getBytes();
        try {
            OutputStream outputStream = stream;
            synchronized (outputStream) {
                stream.write(data);
                stream.write(lineSeparatorBytes);
                stream.write(lineSeparatorBytes);
                stream.flush();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            this.sendOutputToConsole();
        }
    }
}

