/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.osgi.framework.ServiceReference;

public final class ServiceReferenceUtility {
    private static final ServiceReferenceUtility INSTANCE = new ServiceReferenceUtility();

    public static ServiceReferenceUtility getInstance() {
        return INSTANCE;
    }

    private ServiceReferenceUtility() {
    }

    private int compareByServiceRanking(ServiceReference left, ServiceReference right) {
        int leftRanking = this.getServiceRanking(left);
        int rightRanking = this.getServiceRanking(right);
        int result = rightRanking - leftRanking;
        if (result == 0) {
            long leftServiceId = this.getServiceId(left);
            long rightServiceId = this.getServiceId(right);
            result = (int)(leftServiceId - rightServiceId);
        }
        return result;
    }

    public Comparator createServiceRankingComparator() {
        return new Comparator(){

            public int compare(Object left, Object right) {
                ServiceReference leftReference = (ServiceReference)left;
                ServiceReference rightReference = (ServiceReference)right;
                int result = ServiceReferenceUtility.this.compareByServiceRanking(leftReference, rightReference);
                return result;
            }
        };
    }

    public long getServiceId(ServiceReference reference) {
        Assertion.checkArgumentIsNotNull(reference, "reference");
        Number wrapper = (Number)reference.getProperty("service.id");
        long id = wrapper.intValue();
        return id;
    }

    public long[] getServiceIds(ServiceReference[] references) {
        Assertion.checkArgumentIsNotNull(references, "references");
        int length = references.length;
        long[] ids = new long[length];
        int i = 0;
        while (i < length) {
            long id;
            ServiceReference reference = references[i];
            ids[i] = id = this.getServiceId(reference);
            ++i;
        }
        return ids;
    }

    public List getServiceNames(ServiceReference reference) {
        Assertion.checkArgumentIsNotNull(reference, "reference");
        String[] names = (String[])reference.getProperty("objectClass");
        ArrayList<String> list = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            list.add(name);
            ++i;
        }
        return list;
    }

    public List getServiceNames(ServiceReference[] references) {
        Assertion.checkArgumentIsNotNull(references, "references");
        CollectionUtility utility = CollectionUtility.getInstance();
        int size = utility.estimateHashedCollectionSize(references.length * 4);
        HashSet set = new HashSet(size);
        int i = 0;
        while (i < references.length) {
            ServiceReference reference = references[i];
            List names = this.getServiceNames(reference);
            set.addAll(names);
            ++i;
        }
        int count = set.size();
        ArrayList list = new ArrayList(count);
        list.addAll(set);
        return list;
    }

    private int getServiceRanking(ServiceReference reference) {
        int ranking;
        Object value = reference.getProperty("service.ranking");
        if (value instanceof Integer) {
            Number wrapper = (Number)value;
            ranking = wrapper.intValue();
        } else {
            ranking = 0;
        }
        return ranking;
    }

    public boolean isServiceInstanceOf(ServiceReference reference, String name) {
        Assertion.checkArgumentIsNotNull(reference, "reference");
        Assertion.checkArgumentIsNotNull(name, "name");
        boolean match = false;
        List serviceNames = this.getServiceNames(reference);
        Iterator iterator = serviceNames.iterator();
        while (!match && iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            match = name.equals(serviceName);
        }
        return match;
    }

    public ServiceReference select(ServiceReference[] references) {
        Assertion.checkArgumentIsNotNull(references, "references");
        int length = references.length;
        if (length == 0) {
            return null;
        }
        this.sortByServiceRanking(references);
        ServiceReference result = references[0];
        return result;
    }

    private void sortByServiceRanking(ServiceReference[] references) {
        Assertion.checkArgumentIsNotNull(references, "references");
        Comparator comparator = this.createServiceRankingComparator();
        Arrays.sort(references, comparator);
    }
}

