/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractCommandProvider
implements CommandProvider {
    protected static final List EMPTY_LIST = new ArrayList(0);
    private static final char INDENT = '\t';
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String NO_VERSION = "0.0.0";
    private static final char SPACE = ' ';
    private StringBuffer buffer;
    private BundleContext bundleContext;
    private CommandInterpreter interpreter;

    protected AbstractCommandProvider() {
        this.setBuffer(new StringBuffer(4096));
    }

    protected AbstractCommandProvider(BundleContext bundleContext) {
        this();
        this.setBundleContext(bundleContext);
    }

    protected final void append(char value) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(value);
    }

    protected final void append(Collection list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.appendLine(object);
        }
    }

    protected final void append(Object value) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(value);
    }

    protected final void appendIndent() {
        this.append('\t');
    }

    protected final void appendLine(Object value) {
        this.append(value);
        this.appendNewLine();
    }

    protected final void appendNewLine() {
        this.append(LINE_SEPARATOR);
    }

    protected String createBundleStatePadding(Bundle bundle, String state) {
        int stateLength = state.length();
        int length = 12 - stateLength;
        char[] chars = new char[length];
        Arrays.fill(chars, ' ');
        String padding = new String(chars);
        return padding;
    }

    protected final void flushBuffer() {
        String value = this.getBufferContents();
        CommandInterpreter interpreter = this.getInterpreter();
        interpreter.print((Object)value);
    }

    protected final List getAllArguments() {
        String argument = this.getNextArgument();
        if (argument == null) {
            return new ArrayList(0);
        }
        ArrayList<String> list = new ArrayList<String>(5);
        do {
            list.add(argument);
        } while ((argument = this.getNextArgument()) != null);
        return list;
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    private String getBufferContents() {
        StringBuffer buffer = this.getBuffer();
        int length = buffer.length();
        String value = buffer.toString();
        buffer.delete(0, length);
        return value;
    }

    private Bundle getBundle(long id) {
        BundleContext context = this.getBundleContext();
        Bundle bundle = context.getBundle(id);
        return bundle;
    }

    protected final Bundle getBundle(String value) {
        Bundle bundle = null;
        try {
            long id = Long.parseLong(value);
            bundle = this.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {}
        return bundle;
    }

    protected final BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            throw new IllegalStateException("no bundle context");
        }
        return this.bundleContext;
    }

    protected final String getBundleVersion(Bundle bundle) {
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String version = utility.getBundleVersion(bundle);
        if (version == null) {
            version = NO_VERSION;
        }
        return version;
    }

    protected abstract String[] getCommandHelpLines();

    public final String getHelp() {
        String decoration = "---";
        String title = this.getTitle();
        if (title == null) {
            String name;
            Class<?> clazz = this.getClass();
            title = name = clazz.getName();
        }
        this.append(decoration);
        this.append(title);
        this.appendLine(decoration);
        String[] lines = this.getCommandHelpLines();
        if (lines != null) {
            int length = lines.length;
            int i = 0;
            while (i < length) {
                String line = lines[i];
                this.appendIndent();
                this.appendLine(line);
                ++i;
            }
        }
        String result = this.getBufferContents();
        return result;
    }

    protected final CommandInterpreter getInterpreter() {
        return this.interpreter;
    }

    protected final String getNextArgument() {
        CommandInterpreter interpreter = this.getInterpreter();
        String argument = interpreter.nextArgument();
        return argument;
    }

    protected final Bundle getNextArgumentBundle() {
        String id = this.getNextArgument();
        if (id == null) {
            return null;
        }
        Bundle bundle = this.getBundle(id);
        return bundle;
    }

    protected abstract String getTitle();

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected final void setInterpreter(CommandInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    protected final String toBundleIdString(Bundle bundle) {
        long id = bundle.getBundleId();
        String value = String.valueOf(id);
        return value;
    }

    protected final String toBundleStateString(Bundle bundle) {
        BundleUtility utility = BundleUtility.getInstance();
        String value = utility.toBundleStateString(bundle);
        return value;
    }
}

