/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.equinox.console.cmdprov.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.AbstractCommandProvider;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.equinox.console.cmdprov.internal.nls.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationAdminCommandProvider
extends AbstractCommandProvider {
    private static final String CONFIGURATION_PROPERTIES_DESCRIPTION_KEY = "ConfigurationAdminCommandProvider.ConfigurationPropertiesDescription";
    private static final String FACTORY_PIDS_DESCRIPTION_KEY = "ConfigurationAdminCommandProvider.FactoryPidsDescription";
    private static final String PIDS_DESCRIPTION_KEY = "ConfigurationAdminCommandProvider.PidsDescription";
    private static final String TITLE_KEY = "ConfigurationAdminCommandProvider.Title";
    private static final String CONFIGURATION_PROPERTIES_DESCRIPTION = Messages.getString("ConfigurationAdminCommandProvider.ConfigurationPropertiesDescription");
    private static final String FACTORY_PIDS_DESCRIPTION = Messages.getString("ConfigurationAdminCommandProvider.FactoryPidsDescription");
    private static final String PIDS_DESCRIPTION = Messages.getString("ConfigurationAdminCommandProvider.PidsDescription");
    private static final String TITLE = Messages.getString("ConfigurationAdminCommandProvider.Title");
    private static final String CONFIGURATION_PROPERTIES_COMMAND_HELP = "cprops [pid] - {0}";
    private static final String FACTORY_PIDS_COMMAND_HELP = "fpids [filter] - {0}";
    private static final String PIDS_COMMAND_HELP = "pids [filter] - {0}";
    private ConfigurationAdmin model;
    private Comparator configurationComparator;

    public ConfigurationAdminCommandProvider(BundleContext bundleContext, ConfigurationAdmin model) {
        super(bundleContext);
        this.setModel(model);
        this.setConfigurationComparator(this.createConfigurationComparator());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _cprops(CommandInterpreter interpreter) {
        this.setInterpreter(interpreter);
        try {
            List arguments = this.getAllArguments();
            List configurations = this.getConfigurationsByPids(arguments);
            this.appendProperties(configurations);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _fpids(CommandInterpreter interpreter) {
        this.setInterpreter(interpreter);
        String filter = this.getNextArgument();
        try {
            List configurations = this.getConfigurations(filter);
            List fpids = this.getFactoryPids(configurations);
            this.append(fpids);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _pids(CommandInterpreter interpreter) {
        this.setInterpreter(interpreter);
        String filter = this.getNextArgument();
        try {
            List configurations = this.getConfigurations(filter);
            List pids = this.getPids(configurations);
            this.append(pids);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.flushBuffer();
    }

    private void appendProperties(Configuration configuration) {
        String pid = configuration.getPid();
        String location = configuration.getBundleLocation();
        this.append("pid=");
        this.append(pid);
        this.append(", ");
        this.append("location=");
        this.append(location);
        this.appendNewLine();
        Dictionary properties = configuration.getProperties();
        this.appendProperties(properties);
    }

    private void appendProperties(Dictionary properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            boolean isString = value instanceof String;
            this.appendIndent();
            this.append(key);
            this.append(" -> ");
            if (isString) {
                this.append('\"');
            }
            this.append(value);
            if (isString) {
                this.append('\"');
            }
            this.appendNewLine();
        }
    }

    private void appendProperties(List configurations) {
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            this.appendProperties(configuration);
        }
    }

    private int compare(Configuration leftConfiguration, Configuration rightConfiguration) {
        String leftPid = leftConfiguration.getPid();
        String rightPid = rightConfiguration.getPid();
        int result = leftPid.compareTo(rightPid);
        return result;
    }

    private Comparator createConfigurationComparator() {
        return new Comparator(){

            public int compare(Object left, Object right) {
                Configuration leftConfiguration = (Configuration)left;
                Configuration rightConfiguration = (Configuration)right;
                int result = ConfigurationAdminCommandProvider.this.compare(leftConfiguration, rightConfiguration);
                return result;
            }
        };
    }

    protected String[] getCommandHelpLines() {
        return new String[]{this.getConfigurationPropertiesCommandHelpLine(), this.getFactoryPidsCommandHelpLine(), this.getPidsCommandHelpLine()};
    }

    private final Comparator getConfigurationComparator() {
        return this.configurationComparator;
    }

    private String getConfigurationPropertiesCommandHelpLine() {
        return MessageFormatter.format(CONFIGURATION_PROPERTIES_COMMAND_HELP, CONFIGURATION_PROPERTIES_DESCRIPTION);
    }

    private List getConfigurations(String filter) {
        ConfigurationAdmin model = this.getModel();
        List<Configuration> list = null;
        try {
            Configuration[] configurations = model.listConfigurations(filter);
            if (configurations == null) {
                return AbstractCommandProvider.EMPTY_LIST;
            }
            list = Arrays.asList(configurations);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        Comparator comparator = this.getConfigurationComparator();
        Collections.sort(list, comparator);
        return list;
    }

    private List getConfigurationsByPids(List arguments) {
        List configurations = this.getConfigurations(null);
        boolean empty = arguments.isEmpty();
        if (empty) {
            return configurations;
        }
        int size = configurations.size();
        ArrayList<Configuration> hits = new ArrayList<Configuration>(size);
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            String pid = configuration.getPid();
            boolean match = arguments.contains(pid);
            if (!match) continue;
            hits.add(configuration);
        }
        return hits;
    }

    private List getFactoryPids(List configurations) {
        int size = configurations.size();
        ArrayList<String> fpids = new ArrayList<String>(size);
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            String fpid = configuration.getFactoryPid();
            if (fpid == null) continue;
            fpids.add(fpid);
        }
        Collections.sort(fpids);
        return fpids;
    }

    private String getFactoryPidsCommandHelpLine() {
        return MessageFormatter.format(FACTORY_PIDS_COMMAND_HELP, FACTORY_PIDS_DESCRIPTION);
    }

    private final ConfigurationAdmin getModel() {
        return this.model;
    }

    private List getPids(List configurations) {
        int size = configurations.size();
        ArrayList<String> pids = new ArrayList<String>(size);
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            try {
                String pid = configuration.getPid();
                pids.add(pid);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        Collections.sort(pids);
        return pids;
    }

    private String getPidsCommandHelpLine() {
        return MessageFormatter.format(PIDS_COMMAND_HELP, PIDS_DESCRIPTION);
    }

    protected String getTitle() {
        return TITLE;
    }

    private final void setConfigurationComparator(Comparator configurationComparator) {
        this.configurationComparator = configurationComparator;
    }

    private final void setModel(ConfigurationAdmin model) {
        this.model = model;
    }
}

