/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.bundle;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private static final String ABOUT_EXTENSION_POINT = "org.eclipse.soda.sat.plugin.about";
    private List<AboutExtension> aboutExtensions;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private List<AboutExtension> createAboutData() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ABOUT_EXTENSION_POINT);
        IExtension[] extensions = point.getExtensions();
        List<AboutExtension> data = this.processAboutExtensions(extensions);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AboutExtension> getAboutExtensions() {
        Activator activator = this;
        synchronized (activator) {
            if (this.aboutExtensions == null) {
                List<AboutExtension> aboutExtentions = this.createAboutData();
                this.setAboutExtensions(aboutExtentions);
            }
        }
        return this.aboutExtensions;
    }

    private String getSymbolicName() {
        Bundle bundle = this.getBundle();
        String name = bundle.getSymbolicName();
        return name;
    }

    public void log(int severity, String message, Throwable throwable) {
        String id = this.getSymbolicName();
        Status status = new Status(severity, id, 0, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    public void log(int severity, Throwable throwable) {
        String message = throwable.getMessage();
        this.log(severity, message, throwable);
    }

    private List<AboutExtension> processAboutExtensions(IExtension[] extensions) {
        int size = extensions.length;
        ArrayList<AboutExtension> items = new ArrayList<AboutExtension>(size);
        int i = 0;
        while (i < size) {
            IExtension extension = extensions[i];
            AboutExtension data = new AboutExtension(extension);
            items.add(data);
            ++i;
        }
        return items;
    }

    private void setAboutExtensions(List<AboutExtension> aboutExtensions) {
        this.aboutExtensions = aboutExtensions;
    }

    public void stop(BundleContext context) throws Exception {
        this.setAboutExtensions(null);
        super.stop(context);
    }
}

