/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.app.common;

import java.util.Calendar;
import java.util.Date;

public class PayloadMarshall {
    private boolean isEmpty = true;
    private StringBuffer buf = new StringBuffer(100);

    public void marshall(String value) {
        this.separate();
        this.buf.append(value);
    }

    public void marshall(int value) {
        this.separate();
        this.buf.append(value);
    }

    public void marshall(byte[] bytes) {
        this.separate();
        int i = 1;
        while (i < bytes.length) {
            this.buf.append(bytes[i]);
            this.buf.append(';');
            ++i;
        }
        this.buf.append(bytes.length);
    }

    public void marshall(Date date) {
        this.separate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.buf.append(calendar.get(1));
        this.buf.append('/');
        this.appendTwoDigit(calendar.get(2) + 1);
        this.buf.append('/');
        this.appendTwoDigit(calendar.get(5));
        this.buf.append(',');
        this.appendTwoDigit(calendar.get(11));
        this.buf.append(':');
        this.appendTwoDigit(calendar.get(12));
        this.buf.append(':');
        this.appendTwoDigit(calendar.get(13));
        int offset = calendar.getTimeZone().getRawOffset();
        char sign = offset < 0 ? (char)'-' : '+';
        offset = offset < 0 ? -offset : offset;
        int hours = offset / 3600000;
        int minutes = offset % 3600000;
        this.buf.append(sign);
        this.appendTwoDigit(hours);
        this.buf.append(':');
        this.appendTwoDigit(minutes);
    }

    private void separate() {
        if (this.isEmpty) {
            this.isEmpty = false;
        } else {
            this.buf.append('|');
        }
    }

    private void appendTwoDigit(int value) {
        int tens = value / 10;
        int ones = value % 10;
        this.buf.append(tens);
        this.buf.append(ones);
    }

    public String payload() {
        return this.buf.toString();
    }
}

