/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.actuator.message.model;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.common.model.StepstoneModelException;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class Message
extends GenericReading
implements IDataObject {
    private String message;
    private int messagePriority;

    public Message() {
    }

    public Message(Map m) {
        super(m);
        this.messagePriority = (Integer)m.get("PRIORITY");
        this.message = (String)m.get("MESSAGE");
    }

    protected Map getMap() {
        Map map = super.getMap();
        map.put("PRIORITY", new Integer(this.messagePriority));
        map.put("MESSAGE", this.message);
        return map;
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("message", this.getMap());
    }

    public static Message getMessageByTimestamp(IDatabaseConnection conn, Timestamp ts) throws StepstoneDatabaseException, StepstoneModelException {
        List readings = conn.getReadings("message", "MEASUREMENT_TIMESTAMP", (Object)ts, null);
        if (readings.size() == 0) {
            return null;
        }
        if (readings.size() > 1) {
            throw new StepstoneDatabaseException("More than one message with timestamp " + ts);
        }
        return new Message((Map)readings.get(0));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getMessagePriority() {
        return this.messagePriority;
    }

    public void setMessagePriority(int messagePriority) {
        this.messagePriority = messagePriority;
    }
}

