/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.actuator.message.view;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.actuator.message.model.Message;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;

public class MessageServlet
extends HttpServlet {
    static final long serialVersionUID = 0L;
    private final String messagerURL = "/message/messager.jsp";
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public void processAction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Message message = new Message();
        message.setPatientId("12AB78");
        message.setMessage(request.getParameter("message"));
        message.setMessagePriority(Integer.parseInt(request.getParameter("priority")));
        message.setMeasurementTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            message.writeToDatabase(conn);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("message") == null || request.getParameter("priority") == null) {
            response.setContentType("text/html");
            this.setParams(request);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/message/messager.jsp");
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            this.processAction(request, response);
        }
    }

    private void setParams(HttpServletRequest request) {
        request.setAttribute("actionUrl", (Object)request.getRequestURL().toString());
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            request.setAttribute(paramName, (Object)request.getParameter(paramName));
        }
    }
}

