/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.actuator.message.model;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.communications.Timestamper;
import org.eclipse.soda.stepstone.backend.service.communications.IDatabaseTrigger;
import org.eclipse.soda.stepstone.backend.service.communications.IMessageProcessor;

public class MessageTrigger
implements IDatabaseTrigger {
    private static String DEFAULT_EDGE_ID = "edge01";
    private static String MESSAGE_DEVICE_TYPE = "display";
    private static String DEFAULT_DEVICE_ID = "d01";
    private static String ACTUATE_TOPIC = "actuate";
    private static MessageTrigger instance;
    private IMessageProcessor processor;

    public static synchronized MessageTrigger getInstance() {
        if (instance == null) {
            instance = new MessageTrigger();
        }
        return instance;
    }

    public static int messageNotify(Map m) {
        Timestamp ts = new Timestamp(new Date().getTime());
        String id = (String)m.get("PATIENT_ID");
        int priority = (Integer)m.get("PRIORITY");
        String message = (String)m.get("MESSAGE");
        return MessageTrigger.getInstance().instMessageNotify(ts, id, priority, message);
    }

    private MessageTrigger() {
    }

    private int instMessageNotify(Timestamp ts, String id, int priority, String message) {
        String priorityString = "p" + Integer.toString(priority) + "-message";
        this.processor.sendWithoutReply("serverID", ACTUATE_TOPIC, DEFAULT_EDGE_ID, id, MESSAGE_DEVICE_TYPE, DEFAULT_DEVICE_ID, priorityString, message, Timestamper.toUTCStringISO((long)ts.getTime()));
        return 0;
    }

    public void setProcessor(IMessageProcessor processor) {
        this.processor = processor;
    }
}

