/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.actuator.message.view;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.actuator.message.model.Message;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;

public class MessageServlet
extends HttpServlet {
    static final long serialVersionUID = 0L;
    private final String messagerURL = "/devices/message/webFiles/message.html";
    private IDatabaseService dbService;
    private String data;
    private String priority;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public void processAction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Message message = new Message();
        message.setPatientId("12AB78");
        message.setMessage(this.data);
        message.setMessagePriority(Integer.parseInt(this.priority));
        message.setMeasurementTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            message.writeToDatabase(conn);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/devices/message/webFiles/message.html");
        dispatcher.include((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentType().equals("form")) {
            this.priority = request.getParameter("priority");
            this.data = request.getParameter("messageData");
        } else {
            this.priority = this.getPriority(request);
            this.data = this.getMessage(request);
        }
        if (this.data == null || this.priority == null) {
            response.setContentType("text/html");
            this.setParams(request);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/devices/message/webFiles/message.html");
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            this.processAction(request, response);
        }
    }

    /*
     * Exception decompiling
     */
    private String getMessage(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getPriority(HttpServletRequest request) {
        byte[] priorityBytes = request.getHeader("Priority").getBytes();
        return new String(priorityBytes);
    }

    private void setParams(HttpServletRequest request) {
        request.setAttribute("actionUrl", (Object)request.getRequestURL().toString());
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            request.setAttribute(paramName, (Object)request.getParameter(paramName));
        }
    }
}

