/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.adminui;

import java.io.StringWriter;
import java.util.Dictionary;
import org.osgi.framework.Bundle;

public class BundleElement {
    public static final String UNKNOWN_STATE = "UNKNOWN STATE";
    public static final String ACTIVE = "ACTIVE";
    public static final String STOPPING = "STOPPING";
    public static final String STARTING = "STARTING";
    public static final String RESOLVED = "RESOLVED";
    public static final String INSTALLED = "INSTALLED";
    public static final String UNINSTALLED = "UNINSTALLED";
    public static final String DELIMETER = ",";
    private Bundle bundle;

    public BundleElement(Bundle b) {
        this.bundle = b;
    }

    public String getName() {
        return this.bundle.getSymbolicName();
    }

    private String[] getCategories() {
        Dictionary headers = this.bundle.getHeaders();
        String categories = (String)headers.get("Stepstone-BundleCategories");
        if (categories == null) {
            return new String[0];
        }
        return categories.split(DELIMETER);
    }

    public boolean isDeviceBundle() {
        String[] categories = this.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (categories[i].equals("device")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isUtilityBundle() {
        String[] categories = this.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (categories[i].equals("utility")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getElementRendering() {
        StringWriter rendering = new StringWriter();
        rendering.write("<tr><td>" + this.getName() + "</td>");
        rendering.write("<td>" + this.stateString(this.bundle.getState()) + "</td>");
        if (this.bundle.getState() == 4 || this.bundle.getState() == 2) {
            rendering.write("<td><a href=\"admin?activateBundle=" + Long.toString(this.bundle.getBundleId()) + "\">Activate</a></td>");
        } else if (this.bundle.getState() == 32) {
            rendering.write("<td><a href=\"admin?deactivateBundle=" + Long.toString(this.bundle.getBundleId()) + "\">Dectivate</a></td>");
        } else {
            rendering.write("<td></td>");
        }
        rendering.write("</tr>");
        return rendering.toString();
    }

    private String stateString(int stateCode) {
        switch (stateCode) {
            case 1: {
                return UNINSTALLED;
            }
            case 2: {
                return INSTALLED;
            }
            case 4: {
                return RESOLVED;
            }
            case 8: {
                return STARTING;
            }
            case 16: {
                return STOPPING;
            }
            case 32: {
                return ACTIVE;
            }
        }
        return UNKNOWN_STATE;
    }
}

