/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.adminui;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.adminui.BundleElement;
import org.eclipse.soda.stepstone.backend.adminui.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class AdminServlet
extends HttpServlet {
    public static final String FILE_NAME = "fileName";
    private static final long serialVersionUID = 0L;
    private BundleContext context;

    public void bind(BundleContext context) {
        this.context = context;
    }

    public void unbind() {
        this.context = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String bundleId;
        if (req.getParameter(FILE_NAME) != null) {
            this.handleFileUpload(req);
        } else if (req.getParameter("activateBundle") != null) {
            bundleId = req.getParameter("activateBundle");
            Bundle activateMe = this.context.getBundle(new Long(bundleId).longValue());
            try {
                activateMe.start();
            }
            catch (BundleException e) {
                LogUtility.logWarning((String)(String.valueOf(Messages.getString("AdminServlet.1")) + bundleId), (Throwable)e);
            }
        } else if (req.getParameter("deactivateBundle") != null) {
            bundleId = req.getParameter("deactivateBundle");
            Bundle deactivateMe = this.context.getBundle(new Long(bundleId).longValue());
            try {
                deactivateMe.stop();
            }
            catch (BundleException e) {
                LogUtility.logWarning((String)(String.valueOf(Messages.getString("AdminServlet.2")) + bundleId), (Throwable)e);
            }
        }
        Bundle[] bundles = this.context.getBundles();
        BundleElement[] elements = new BundleElement[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            elements[i] = new BundleElement(bundles[i]);
            ++i;
        }
        req.setAttribute("bundles", (Object)elements);
        if (req.getParameter(FILE_NAME) != null) {
            resp.sendRedirect("/admin/admin.jsp");
        } else {
            RequestDispatcher dispatcher = req.getRequestDispatcher("/admin/admin.jsp");
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void handleFileUpload(HttpServletRequest req) {
        String fileName = req.getParameter(FILE_NAME);
        try {
            Bundle newBundle = this.context.installBundle(fileName);
            newBundle.start();
        }
        catch (BundleException e) {
            LogUtility.logWarning((String)(String.valueOf(Messages.getString("AdminServlet.3")) + fileName), (Throwable)e);
        }
    }
}

