<%@ page import="org.eclipse.soda.stepstone.backend.adminui.BundleElement" %>

<jsp:useBean id="bundles" type="BundleElement[]" scope="request"/>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en-AU">
  <head>
    <title>Stepstone</title>
  </head>
  
  <script type="text/javascript" src="http://o.aolcdn.com/dojo/1.1.1/dojo/dojo.xd.js" djConfig="parseOnLoad: true"></script>
  <script type="text/javascript" src="http://o.aolcdn.com/dojo/1.1.1/dojox/gfx.js"></script> 
  <script language="JavaScript" type="text/javascript">	
		dojo.require("dojo.parser");
		
		dojo.require("dijit.layout.TabContainer");
		dojo.require("dijit.layout.ContentPane");
		
		dojo.require("dojox.data.HtmlTableStore");
		dojo.require("dojox.grid.Grid");
		
		function activate(){
			if(bundles = getSelected()){
				alert("activate " + bundles);
			}
			else alert("No rows are selected.");
			}
		function deactivate(){
			if(bundles = getSelected()){
				alert("deactivate " + bundles);
			}
			else alert("No rows are selected.");
		}
		function uninstall(){
			if(bundles = getSelected()){
				alert("uninstall " + bundles);
			}
			else alert("No rows are selected.");
		}
		//returns the selected patient if none are selected
		function getSelected(){
			var deviceTable=dijit.byId("deviceTable");
			var utilityTable=dijit.byId("utilityTable");
			if(deviceTable){
				var selectedBundles = deviceTable.model.getDatum(deviceTable.selection.getSelected(),0);
			} else if(utilityTable){
				var selectedBundles = utilityTable.model.getDatum(utilityTable.selection.getSelected(),0);
			}
			return selectedBundles;
		}

		var view =	{ cells: [[{name: 'Bundle Name', width: '400px', field: 'BundleName'}, 
					{name: 'State', width: '200px', field:'State'},
					{name: 'Action', width: '200px', field:'Action'}]]
			};
		var layout = [ view ];
  </script>
  <style type="text/css">
		@import "http://o.aolcdn.com/dojo/1.1.1/dijit/themes/tundra/tundra.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dojo/resources/dojo.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dijit/tests/css/dijitTests.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dojox/grid/_grid/tundraGrid.css";
	</style>
  <body class="tundra">
    <div id="header">
      <div class="superHeader">
        <div class="left">
          <span class="doNotDisplay">Related sites:</span>
			<a href="index" target="_top">Return</a>
        </div>
      </div>

      <div class="midHeader">
        <h1 class="headerTitle">Stepstone</h1>
      </div>
<hr />
  <div class="subHeader">
      	<b>Milestone 3</b>
      </div>
    </div>

    <div id="main-copy">
	    <!-- <div>
			<button onclick="activate();">Activate</button>
			<button onclick="deactivate();">Deactivate</button>
			<button onclick="uninstall();">Uninstall</button>
		</div> -->
		
  		<h3>Devices</h3>
  		
  		<div dojoType="dojox.data.HtmlTableStore" tableId="deviceTable" jsId="deviceTableStore"></div>
		<div dojoType="dojox.grid.data.DojoData" store="deviceTableStore" query="{}" jsId="deviceModel"></div>

       	<table id="deviceTable" style="border-spacing: 12px;"> <!-- dojoType="dojox.Grid" model="deviceModel" structure="layout" style="height: 200px; width: 830px;"> --> 
       	<thead>
       		<tr>
       	    	<th>BundleName</th>
       			<th>State</th>
       			<th>Action</th>
       		</tr>
       	</thead>
       	<tbody>
       		<%
	        for (int i = 0; i < bundles.length; i++) {
	            if (bundles[i].isDeviceBundle()) {
	        %>
	        	<%= bundles[i].getElementRendering() %>
	        <% } } %>
       	</tbody>
       	</table>

  		<h3>Utilities</h3>
  		<div dojoType="dojox.data.HtmlTableStore" tableId="utilityTable" jsId="utilityTableStore"></div>
		<div dojoType="dojox.grid.data.DojoData" store="utilityTableStore" query="{}" jsId="utilityModel"></div>
  		
       	<table id="utilityTable" style="border-spacing: 12px;"> <!--  dojoType="dojox.Grid" model="utilityModel" structure="layout" style="height: 100px; width: 830px;"> -->
       	<thead>
       		<tr>
       	    	<th>BundleName</th>
       			<th>State</th>
       			<th>Action</th>
       		</tr>
       	</thead>
       	<tbody>
       		<%
	        for (int i = 0; i < bundles.length; i++) {
	            if (bundles[i].isUtilityBundle()) {
	        %>
	        	<%= bundles[i].getElementRendering() %>
	        <% } } %>
       	</tbody>
       	</table>

        <h3>Upload new bundle</h3>
        <form method="post" action="admin">
        	<input type="text" name="fileName">
        	<input type="submit" value="Upload"/>
        </form>
  	</div>
  </body>
</html>