/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.alertstatus;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.alertstatus.AlertCollector;
import org.eclipse.soda.stepstone.backend.common.communications.Alert;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.osgi.service.event.Event;

public class AlertStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private IGlobalStoreService globalStore;

    public void bind(IGlobalStoreService globalStore) {
        this.globalStore = globalStore;
    }

    public void unbind() {
        this.globalStore = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String patientID = (String)this.globalStore.get("currentPatient");
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        String details = req.getParameter("details");
        if (patientID == null) {
            writer.println("<p>Please select a patient at left</p>");
        } else if (details == null) {
            String statusColor = "green";
            if (AlertCollector.getInstance().getAlertsForPatient(patientID, Alert.CRITICAL).size() > 0) {
                statusColor = "red";
            } else if (AlertCollector.getInstance().getAlertsForPatient(patientID, Alert.WARNING).size() > 0) {
                statusColor = "lightyellow";
            }
            String url = req.getRequestURI();
            url = String.valueOf(url) + "?";
            String query = req.getQueryString();
            if (query != null) {
                url = String.valueOf(url) + query + "&";
            }
            url = String.valueOf(url) + "details=true";
            writer.println("<a href=\"" + url + "\">");
            writer.println("<img src=\"alertstatus-servlet/" + statusColor + "_orb.png\">");
            writer.println("</a>");
        } else {
            List alerts = AlertCollector.getInstance().getAlertsForPatient(patientID, null);
            if (alerts.size() == 0) {
                writer.println("No alerts for patientID " + patientID);
            } else {
                Iterator i = alerts.iterator();
                while (i.hasNext()) {
                    Event thisAlert = (Event)i.next();
                    writer.println("<p>" + thisAlert.getProperty("serverity") + ": " + thisAlert.getProperty("value") + "</p>");
                }
            }
        }
    }
}

