/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.alertstatus;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.alertstatus.AlertCollector;
import org.eclipse.soda.stepstone.backend.common.communications.Alert;
import org.osgi.service.event.Event;

public class AlertStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private AlertCollector alertService;

    public void bind(AlertCollector alertCollector) {
        this.alertService = alertCollector;
    }

    public void unbind() {
        this.alertService = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter writer = resp.getWriter();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            String patientId = req.getPathInfo().substring(1);
            List alerts = this.alertService.getAlertsForPatient(patientId, null);
            String statusColor = "green";
            if (this.alertService.getAlertsForPatient(patientId, Alert.CRITICAL).size() > 0) {
                statusColor = "red";
            } else if (this.alertService.getAlertsForPatient(patientId, Alert.WARNING).size() > 0) {
                statusColor = "lightyellow";
            }
            writer.println("<img src=\"../alerts/" + statusColor + "_orb.png\" />");
            if (alerts.size() == 0) {
                writer.println("No alerts for patientID " + patientId);
            } else {
                Iterator i = alerts.iterator();
                while (i.hasNext()) {
                    Event thisAlert = (Event)i.next();
                    writer.println("<p>" + thisAlert.getProperty("serverity") + ": " + thisAlert.getProperty("value") + "</p>");
                }
            }
        } else {
            resp.sendError(501);
        }
    }
}

