/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common;

import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.osgi.service.event.EventAdmin;

public abstract class DataActivator
extends BaseBundleActivator {
    private IDataComponent component;
    private IDeviceService deviceService;
    private IDatabaseService dbService;
    private EventAdmin eventManagerService;
    static /* synthetic */ Class class$0;

    protected abstract IDataComponent getComponent();

    protected abstract void createTable(IDatabaseConnection var1) throws StepstoneDatabaseException;

    protected abstract void addObservers();

    protected abstract void removeObservers();

    protected void activate() {
        this.component = this.getComponent();
        this.deviceService = this.getDeviceService();
        this.deviceService.registerDataComponent(this.component);
        this.dbService = this.getDatabaseService();
        this.eventManagerService = this.getEventManagerService();
        try {
            IDatabaseConnection dc = this.dbService.getDatabaseConnection();
            this.createTable(dc);
            dc.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logWarning((Object)((Object)this), (String)"Problem creating database table for device", (Throwable)e);
        }
        this.registerAdditionalServices();
        this.addObservers();
        super.activate();
    }

    protected void deactivate() {
        this.removeObservers();
        this.deviceService.deregisterDataComponent(this.component);
        super.deactivate();
    }

    protected String[] getImportedServiceNames() {
        String[] stringArray = new String[4];
        stringArray[0] = IDatabaseService.SERVICE_NAME;
        stringArray[1] = IDeviceService.SERVICE_NAME;
        stringArray[2] = IGlobalStoreService.SERVICE_NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz.getName();
        return stringArray;
    }

    protected void registerAdditionalServices() {
    }

    protected IDatabaseService getDatabaseService() {
        return (IDatabaseService)this.getImportedService(IDatabaseService.SERVICE_NAME);
    }

    protected IDeviceService getDeviceService() {
        return (IDeviceService)this.getImportedService(IDeviceService.SERVICE_NAME);
    }

    protected IGlobalStoreService getGlobalStoreService() {
        return (IGlobalStoreService)this.getImportedService(IGlobalStoreService.SERVICE_NAME);
    }

    protected EventAdmin getEventManagerService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EventAdmin)this.getImportedService(clazz.getName());
    }
}

