/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common;

import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReadingDatabaseWriter
implements EventHandler {
    IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public void handleEvent(Event event) {
        GenericReading reading = (GenericReading)event.getProperty("value");
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            reading.writeToDatabase(conn);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logWarning((String)"Problem writing data reading to database", (Throwable)e);
        }
    }
}

