/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common.communications;

import java.text.ParseException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.common.communications.EdgeRegistryService;
import org.eclipse.soda.stepstone.backend.service.communications.ICommunications;
import org.eclipse.soda.stepstone.backend.service.communications.IMessageProcessor;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class MessageProcessor
implements IMessageProcessor {
    private static MessageProcessor instance;
    private IDeviceService deviceService;
    private EventAdmin eventService;

    public void bind(IDeviceService deviceService, EventAdmin eventService) {
        this.deviceService = deviceService;
        this.eventService = eventService;
    }

    public void unbind() {
        this.deviceService = null;
        this.eventService = null;
    }

    public static synchronized MessageProcessor getInstance() {
        if (instance == null) {
            instance = new MessageProcessor();
        }
        return instance;
    }

    public void communicationsError(ICommunications comm, String errorMessage, boolean recoverable) {
        LogUtility.logError((String)errorMessage);
        if (!recoverable) {
            this.destroy(comm);
        }
    }

    public void processIncomingMessage(String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, String dateTime) {
        if (parameterName == null) {
            LogUtility.logError((String)"Reading cannot have a null parameter name");
            return;
        }
        IDataMessageParser parser = this.deviceService.getDataMessageParserForReadingType(parameterName);
        if (parser == null) {
            LogUtility.logError((String)("Parser not found for reading type: " + parameterName));
            return;
        }
        IDataObject object = null;
        try {
            object = parser.parseMessage(parameterValue, unitId, deviceId, dateTime);
        }
        catch (ParseException e) {
            LogUtility.logError((String)"Problem parsing message", (Throwable)e);
            return;
        }
        Hashtable<String, Object> reading = new Hashtable<String, Object>();
        ((Dictionary)reading).put("value", object);
        ((Dictionary)reading).put("category", "reading");
        ((Dictionary)reading).put("device", parameterName);
        Event incomingReadingEvent = new Event("stepstone/" + parameterName, reading);
        this.eventService.postEvent(incomingReadingEvent);
    }

    public void sendWithoutReply(String serverId, String sendType, String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, String dateTime) {
        ICommunications communications = EdgeRegistryService.getInstance().getEdgeProxy(edgeId).getDefaultCommunications();
        communications.sendMessage(serverId, sendType, edgeId, unitId, deviceType, deviceId, parameterName, parameterValue, dateTime);
    }

    private void destroy(ICommunications comm) {
        LogUtility.logInfo((String)("shutting down communications: " + comm.getClass().getName()));
        comm.shutDown();
    }
}

