/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common.communications;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class Timestamper {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");

    public static Calendar parse(String Timestamp2) throws ParseException {
        String[] timestampStrings = Timestamp2.split(",");
        if (timestampStrings.length != 2) {
            throw new ParseException("Unknown timestamp format", 0);
        }
        String dateString = timestampStrings[0];
        String timeAndOffset = timestampStrings[1];
        String time = timeAndOffset.substring(0, 8);
        Character plusOrMinus = new Character(timeAndOffset.charAt(8));
        String offset = timeAndOffset.substring(9);
        String dateAndTime = String.valueOf(dateString) + " " + time + " GMT" + plusOrMinus + offset;
        sdf.parse(dateAndTime);
        return sdf.getCalendar();
    }

    public static String toString(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return Timestamper.toString(cal);
    }

    public static String toString(Calendar cal) {
        int offset = cal.get(15) + cal.get(16);
        Calendar calUTC = (Calendar)cal.clone();
        calUTC.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
        DecimalFormat toDigits = new DecimalFormat("0000");
        String year = toDigits.format(cal.get(1));
        toDigits = new DecimalFormat("00");
        String day = toDigits.format(cal.get(5));
        String month = toDigits.format(cal.get(2) + 1);
        String hours = toDigits.format(cal.get(11));
        String minutes = toDigits.format(cal.get(12));
        String seconds = toDigits.format(cal.get(13));
        String sign = offset < 0 ? "-" : "+";
        String hoursOffset = toDigits.format(Math.abs(cal.get(11) - calUTC.get(11)));
        String minutesOffset = toDigits.format(Math.abs(cal.get(12) - calUTC.get(12)));
        return String.valueOf(year) + "/" + month + "/" + day + "," + hours + ":" + minutes + ":" + seconds + sign + hoursOffset + ":" + minutesOffset;
    }

    public static String toUTCStringISO(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return Timestamper.toUTCStringISO(cal);
    }

    public static String toUTCStringISO(Calendar cal) {
        Calendar calUTC = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
        calUTC.setTimeInMillis(cal.getTimeInMillis());
        DecimalFormat toDigits = new DecimalFormat("0000");
        String year = toDigits.format(calUTC.get(1));
        toDigits = new DecimalFormat("00");
        String day = toDigits.format(calUTC.get(5));
        String month = toDigits.format(calUTC.get(2) + 1);
        String hours = toDigits.format(calUTC.get(11));
        String minutes = toDigits.format(calUTC.get(12));
        String seconds = toDigits.format(calUTC.get(13));
        return String.valueOf(year) + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "Z";
    }

    public static Calendar convertToDateTime(String source) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            SimpleDateFormat sdf = null;
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new ParseException("Invalid DateTime String", 0);
            }
            if (source.length() == 20) {
                if (source.charAt(19) != 'Z') {
                    throw new ParseException("Invalid DateTime String", 19);
                }
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                cal.setTime(sdf.parse(source));
            } else if (source.length() == 25) {
                if (source.charAt(19) != '+' && source.charAt(19) != '-' || source.charAt(22) != ':') {
                    throw new ParseException("Invalid DateTime String", 19);
                }
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                String[] timestampStrings = source.split("T");
                if (timestampStrings.length != 2) {
                    throw new ParseException("Unknown timestamp format", 0);
                }
                String dateString = timestampStrings[0];
                String timeAndOffset = timestampStrings[1];
                String time = timeAndOffset.substring(0, 8);
                Character plusOrMinus = new Character(timeAndOffset.charAt(8));
                String offset = timeAndOffset.substring(9);
                String dateAndTime = String.valueOf(dateString) + " " + time + " GMT" + plusOrMinus + offset;
                cal.setTime(sdf.parse(dateAndTime));
            }
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
        return cal;
    }
}

