/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common.view;

import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;

public class ChartMaker {
    private static Date[] getDateMarkCollection(DatedReading[][] data) {
        Date earliest = new Date(Long.MAX_VALUE);
        Date latest = new Date(0L);
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                if (data[i][j].date.after(latest)) {
                    latest = data[i][j].date;
                }
                if (data[i][j].date.before(earliest)) {
                    earliest = data[i][j].date;
                }
                ++j;
            }
            ++i;
        }
        Calendar calLatest = Calendar.getInstance();
        calLatest.setTime(latest);
        Calendar calEarliest = Calendar.getInstance();
        calEarliest = Calendar.getInstance();
        calEarliest.setTime(earliest);
        return new Date[]{calEarliest.getTime(), calLatest.getTime()};
    }

    public static String chart(DatedReading[][] data, int scaleY, Number warning, Number error) {
        long minorTick;
        long majorTick;
        long YEAR = Long.parseLong("31556926000");
        long MONTH = Long.parseLong("2629743830");
        if (data[0].length == 0) {
            return "No readings";
        }
        Date[] markedDates = ChartMaker.getDateMarkCollection(data);
        long rangeX = markedDates[markedDates.length - 1].getTime() - markedDates[0].getTime();
        if (rangeX == 0L) {
            majorTick = 86400000L;
            minorTick = 43200000L;
        } else if (rangeX < 10000L) {
            majorTick = rangeX / 10L;
            minorTick = rangeX / 100L;
        } else if (rangeX < 600000L) {
            majorTick = 10000L;
            minorTick = 1000L;
        } else if (rangeX < 900000L) {
            majorTick = 600000L;
            minorTick = 10000L;
        } else if (rangeX < 3600000L) {
            majorTick = 900000L;
            minorTick = 600000L;
        } else if (rangeX < 43200000L) {
            majorTick = 3600000L;
            minorTick = 900000L;
        } else if (rangeX < 86400000L) {
            majorTick = 43200000L;
            minorTick = 3600000L;
        } else if (rangeX < 604800000L) {
            majorTick = 86400000L;
            minorTick = 43200000L;
        } else if (rangeX < MONTH) {
            majorTick = 604800000L;
            minorTick = 86400000L;
        } else if (rangeX < YEAR) {
            majorTick = MONTH;
            minorTick = 86400000L;
        } else if (rangeX < YEAR * 100L) {
            majorTick = YEAR;
            minorTick = MONTH;
        } else {
            majorTick = rangeX / 10L;
            minorTick = rangeX / 100L;
        }
        double max = 0.0;
        double min = 2.147483647E9;
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                if (data[i][j].value.doubleValue() > max) {
                    max = data[i][j].value.doubleValue();
                }
                if (data[i][j].value.doubleValue() < min) {
                    min = data[i][j].value.doubleValue();
                }
                ++j;
            }
            ++i;
        }
        if (warning != null) {
            max = Math.max(max, warning.doubleValue());
            min = Math.min(min, warning.doubleValue());
        }
        if (error != null) {
            max = Math.max(max, error.doubleValue());
            min = Math.min(min, error.doubleValue());
        }
        min = (double)scaleY * (min / (double)scaleY - 1.0);
        max = (double)scaleY * (max / (double)scaleY + 1.0);
        double yspan = max - min;
        if ((yspan -= yspan % 5.0) == 0.0) {
            yspan = scaleY;
        }
        StringWriter out = new StringWriter();
        out.write("<div dojoType='dijit.layout.ContentPane'>\n");
        out.write("    <div dojoType='dojox.charting.widget.Chart2D' style='width: 300px; height: 300px;'>\n");
        out.write("        <div class='axis' name='x' fixLower='major' fixUpper='major' majorTickStep='" + majorTick + "' minorTickStep='" + minorTick + "'>\n");
        out.write("        </div>\n");
        out.write("        <div class='axis' name='y' vertical='true' min='" + min + "' max='" + max + "' fixLower='major' fixUpper='major' majorTickStep='" + yspan + "'>\n");
        out.write("        </div>\n");
        out.write("        <div class='plot' name='default' type='Default' markers='true'>\n");
        out.write("        </div>\n");
        out.write("        <div class='plot' name='grid' type='Grid'>\n");
        out.write("        </div>\n");
        int i2 = 0;
        while (i2 < data.length) {
            String seriesString = "[";
            int j = 0;
            while (j < data[i2].length) {
                if (j != 0) {
                    seriesString = String.valueOf(seriesString) + ", ";
                }
                seriesString = String.valueOf(seriesString) + data[i2][j];
                ++j;
            }
            seriesString = String.valueOf(seriesString) + "]";
            out.write("        <div class='series' name='Series " + i2 + "' array='" + seriesString + "'>\n");
            out.write("        </div>\n");
            ++i2;
        }
        out.write("    </div>\n");
        out.write("</div>\n");
        return out.toString();
    }

    public static class DatedDoubleReading
    extends DatedReading {
        public DatedDoubleReading(Date d, double v) {
            super(d);
            this.value = new Double(v);
        }
    }

    public static class DatedIntReading
    extends DatedReading {
        public DatedIntReading(Date d, int v) {
            super(d);
            this.value = new Integer(v);
        }
    }

    public static abstract class DatedReading {
        public Date date;
        public Number value;

        public DatedReading(Date d) {
            this.date = d;
        }

        public String toString() {
            return "{x: " + this.date.getTime() + ", y: " + this.value + "}";
        }
    }
}

