/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common.view;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;

public abstract class DataViewServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private IGlobalStoreService globalStore;
    private IDeviceService deviceService;

    public void bind(IGlobalStoreService globalStore, IDeviceService deviceService) {
        this.globalStore = globalStore;
        this.deviceService = deviceService;
    }

    public void unbind() {
        this.globalStore = null;
        this.deviceService = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<h3 style=\"margin-top: 0px\">" + this.getDeviceName() + "</h3>");
        String patientId = (String)this.globalStore.get("currentPatient");
        IMarkupGenerator generator = this.deviceService.getMarkupGeneratorForTag(this.getDataType());
        String[][] tags = this.getViewTags(patientId != null);
        writer.println("<div id=\"tabContainer\" dojoType=\"dijit.layout.TabContainer\" jsId=\"tabs\" selectedTab=\"" + tags[0][0] + "\" style=\"width: 100%;\">");
        int i = 0;
        while (i < tags.length) {
            try {
                writer.println("<div id=\"" + tags[i][0] + "\" " + "dojoType=\"dijit.layout.ContentPane\" " + "title=\"" + tags[i][1] + "\">");
                writer.println(generator.markup(patientId, tags[i][0]));
                writer.println("</div>");
            }
            catch (MarkupGeneratorException e) {
                throw new ServletException((Throwable)e);
            }
            ++i;
        }
        writer.println("</div>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected abstract String[][] getViewTags(boolean var1);

    protected abstract String getDataType();

    protected abstract String getDeviceName();
}

