/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.common.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;
import org.eclipse.soda.stepstone.backend.service.patient.IPatientService;

public abstract class DataViewServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    protected IPatientService patientService;
    protected IDeviceService deviceService;

    public void bind(IDeviceService deviceService, IPatientService patientService) {
        this.patientService = patientService;
        this.deviceService = deviceService;
    }

    public void unbind() {
        this.patientService = null;
        this.deviceService = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String patientId = this.checkAdditionalPathInfo(request);
        String mimeType = this.getMIMEType(request);
        response.setContentType(mimeType);
        PrintWriter writer = response.getWriter();
        IMarkupGenerator generator = this.deviceService.getMarkupGeneratorForTag(this.getDataType());
        try {
            ((Writer)writer).write(generator.markup(patientId, mimeType));
        }
        catch (MarkupGeneratorException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected String getMIMEType(HttpServletRequest request) {
        if (request.getHeader("Accept").equals("application/json")) {
            return "application/json";
        }
        return "text/html";
    }

    protected String checkAdditionalPathInfo(HttpServletRequest request) {
        String path = request.getQueryString();
        if (path != null && !path.equals("null") && path.length() > 1) {
            return path.replaceAll("patientId=", "");
        }
        return null;
    }

    protected abstract String getDeviceName();

    protected abstract String getDefaultDisplayType();

    protected abstract String getDataType();
}

