/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.communications.webservices;

import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.communications.webservices.SoaServiceClient;
import org.eclipse.soda.stepstone.backend.service.communications.ICommunications;
import org.eclipse.soda.stepstone.backend.service.communications.IEdgeRegistryService;
import org.eclipse.soda.stepstone.backend.service.communications.IMessageProcessor;
import org.eclipse.soda.stepstone.backend.soa.api.SendWithoutReply;

public class WebservicesCommunications
implements ICommunications {
    private IMessageProcessor processor;
    private IEdgeRegistryService edgeRegistry;
    boolean running;
    private static WebservicesCommunications instance;

    public void bind(IEdgeRegistryService edgeRegistry) {
        this.edgeRegistry = edgeRegistry;
    }

    public void unbind() {
        this.edgeRegistry = null;
    }

    public static synchronized WebservicesCommunications getInstance() {
        if (instance == null) {
            instance = new WebservicesCommunications();
        }
        return instance;
    }

    public void sendMessage(String serverId, String sendType, String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, String dateTime) {
        try {
            SendWithoutReply doc = new SendWithoutReply();
            doc.setServerId(serverId);
            doc.setSendType(sendType);
            doc.setEdgeId(edgeId);
            doc.setUnitId(unitId);
            doc.setDeviceType(deviceType);
            doc.setDeviceId(deviceId);
            doc.setParameterName(parameterName);
            doc.setParameterValue(parameterValue);
            doc.setDateTime(dateTime);
            SoaServiceClient stub = new SoaServiceClient(this.edgeRegistry.getEdgeProxy(edgeId).getTarget());
            stub.sendWithoutReply(doc);
            LogUtility.logDebug((Object)"WebservicesCommunications", (String)"sent:");
            LogUtility.logDebug((String)("... serverId=" + serverId + "; sendType=" + sendType + "; edgeId=" + edgeId));
            LogUtility.logDebug((String)("... unitId=" + unitId + "; deviceType=" + deviceType + "; deviceId=" + deviceId));
            LogUtility.logDebug((String)("... parameterName=" + parameterName + "; parameterValue=" + parameterValue + "; dateTime=" + dateTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processor.communicationsError((ICommunications)this, "Error sending message: " + e.getMessage(), true);
            return;
        }
    }

    public void shutDown() {
        this.running = false;
    }

    public void startUp(IMessageProcessor p) {
        this.processor = p;
        this.run();
    }

    public IMessageProcessor getProcessor() {
        return this.processor;
    }

    public void run() {
        this.running = true;
    }

    public void processMessage(String sendType, String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, String dateTime) {
        LogUtility.logDebug((Object)"WebservicesCommunications", (String)"received:");
        LogUtility.logDebug((String)("... sendType=" + sendType + "; edgeId=" + edgeId));
        LogUtility.logDebug((String)("... unitId=" + unitId + "; deviceType=" + deviceType + "; deviceId=" + deviceId));
        LogUtility.logDebug((String)("... parameterName=" + parameterName + "; parameterValue=" + parameterValue + "; dateTime=" + dateTime));
        if (sendType.equals("sense")) {
            this.processor.processIncomingMessage(edgeId, unitId, deviceType, deviceId, parameterName, parameterValue, dateTime);
        }
    }
}

