/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.bloodpressure;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.soda.stepstone.backend.common.communications.Alert;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.model.BloodPressureReading;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class BloodPressureAlert
implements EventHandler {
    private EventAdmin eventService;
    private Map interests = new HashMap();

    public void bind(EventAdmin eventService) {
        this.eventService = eventService;
    }

    public void unbind() {
        this.eventService = null;
    }

    public BloodPressureAlert() {
        this.interests.put("category", "reading");
        this.interests.put("device", "bloodPressure");
    }

    private Event buildEvent(BloodPressureReading bp, String alertLevel) {
        Properties metadata = new Properties();
        ((Dictionary)metadata).put("category", "alert");
        ((Dictionary)metadata).put("severity", alertLevel);
        ((Dictionary)metadata).put("patient", bp.getPatientId());
        ((Dictionary)metadata).put("timestamp", bp.getMeasurementTimestamp().toString());
        Alert alert = new Alert("ALERT:  Systolic blood pressure reading too high: " + Integer.toString(bp.getSystolic()), alertLevel);
        ((Dictionary)metadata).put("value", alert);
        Event ev = new Event("stepstone/bloodPressure", (Dictionary)metadata);
        return ev;
    }

    public Map getInterests() {
        return this.interests;
    }

    public void handleEvent(Event event) {
        BloodPressureReading bp = (BloodPressureReading)((Object)event.getProperty("value"));
        if (bp.getSystolic() >= Integer.parseInt(System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.alert", "160"))) {
            this.eventService.postEvent(this.buildEvent(bp, Alert.CRITICAL));
        } else if (bp.getSystolic() >= Integer.parseInt(System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.warn", "140"))) {
            this.eventService.postEvent(this.buildEvent(bp, Alert.WARNING));
        }
    }
}

