/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.bloodpressure;

import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.communications.BloodPressureMessageParser;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.model.BloodPressureReading;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.view.BloodPressureMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.database.StringWithLength;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;

public class BloodPressureComponent
implements IDataComponent {
    private IDatabaseService dbService;
    private BloodPressureMarkupGenerator markupGenerator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
        if (this.markupGenerator != null) {
            this.markupGenerator.unbind();
        }
        this.markupGenerator = null;
    }

    public IDataMessageParser getMessageParser() {
        return new BloodPressureMessageParser();
    }

    public IMarkupGenerator getMarkupGenerator() {
        if (this.markupGenerator == null) {
            this.markupGenerator = new BloodPressureMarkupGenerator();
            this.markupGenerator.bind(this.dbService);
        }
        return this.markupGenerator;
    }

    public String getMessageTypeTag() {
        return "bloodPressure";
    }

    public String getServletTag() {
        return "bloodPressure-servlet";
    }

    public String getDeviceName() {
        return "Blood Pressure";
    }

    public static void createTable(IDatabaseConnection conn) throws StepstoneDatabaseException {
        if (conn.tableExists("blood_pressure")) {
            return;
        }
        String[] fieldNames = new String[]{"MEASUREMENT_TIMESTAMP", "PATIENT_ID", "SYSTOLIC", "SYSTOLIC_RELATIVE", "DIASTOLIC", "MEAN_ARTERIAL_PRESSURE", "HEART_RATE"};
        Object[] objectArray = new Object[7];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        objectArray[1] = new StringWithLength(10);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[2] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[3] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[4] = clazz4;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[5] = clazz5;
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[6] = clazz6;
        Object[] types = objectArray;
        conn.createTable("blood_pressure", fieldNames, types);
    }

    public boolean isPatientViewable() {
        return true;
    }

    public IDataObject[] getAllReadingsForPatient(String id) {
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            return BloodPressureReading.getAllBloodPressureReadingsForId(conn, id);
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logWarning((String)("Problem retrieving blood pressure readings for patient " + id), (Throwable)e);
            return null;
        }
    }
}

