/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.bloodpressure.communications;

import java.text.ParseException;
import org.eclipse.soda.stepstone.backend.common.communications.GenericMessageParser;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.model.BloodPressureReading;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;

public class BloodPressureMessageParser
extends GenericMessageParser
implements IDataMessageParser {
    private static final int NUMOFPARAMS = 3;

    public GenericReading getNewComponentReading() {
        return new BloodPressureReading();
    }

    public GenericReading parseDataMessage(String messageValue) throws ParseException {
        try {
            BloodPressureReading reading = new BloodPressureReading();
            String[] subMessages = messageValue.split("\\|");
            if (subMessages.length != 3) {
                throw new ParseException("Invalid Blood Pressure Reading", 0);
            }
            reading.setSystolic(Integer.parseInt(subMessages[0]));
            reading.setDiastolic(Integer.parseInt(subMessages[1]));
            reading.setHeartRate(Integer.parseInt(subMessages[2]));
            return reading;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid Blood Pressure Reading", 0);
        }
    }
}

