/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.bloodpressure.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class BloodPressureReading
extends GenericReading
implements IDataObject {
    private int systolic;
    private int systolicRelative;
    private int diastolic;
    private int meanArterialPressure;
    private int heartRate;

    public static BloodPressureReading[] getAllBloodPressureReadingsForId(IDatabaseConnection c, String id) throws StepstoneDatabaseException {
        List readings = c.getReadings("blood_pressure", "PATIENT_ID", (Object)id, "MEASUREMENT_TIMESTAMP", 100);
        return BloodPressureReading.convertFromList(readings);
    }

    public static BloodPressureReading[] getAllBloodPressureReadings(IDatabaseConnection c) throws StepstoneDatabaseException {
        List readings = c.getReadings("blood_pressure", null, null, "MEASUREMENT_TIMESTAMP", 100);
        return BloodPressureReading.convertFromList(readings);
    }

    private static BloodPressureReading[] convertFromList(List readings) {
        Iterator it = readings.iterator();
        ArrayList<BloodPressureReading> readingsList = new ArrayList<BloodPressureReading>();
        while (it.hasNext()) {
            readingsList.add(new BloodPressureReading((Map)it.next()));
        }
        return readingsList.toArray(new BloodPressureReading[0]);
    }

    public BloodPressureReading(Map m) {
        super(m);
        this.systolic = (Integer)m.get("SYSTOLIC");
        this.systolicRelative = (Integer)m.get("SYSTOLIC_RELATIVE");
        this.diastolic = (Integer)m.get("DIASTOLIC");
        this.meanArterialPressure = (Integer)m.get("MEAN_ARTERIAL_PRESSURE");
        this.heartRate = (Integer)m.get("HEART_RATE");
    }

    public BloodPressureReading() {
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("blood_pressure", this.getMap());
    }

    protected Map getMap() {
        Map map = super.getMap();
        map.put("SYSTOLIC", new Integer(this.systolic));
        map.put("SYSTOLIC_RELATIVE", new Integer(this.systolicRelative));
        map.put("DIASTOLIC", new Integer(this.diastolic));
        map.put("MEAN_ARTERIAL_PRESSURE", new Integer(this.meanArterialPressure));
        map.put("HEART_RATE", new Integer(this.heartRate));
        return map;
    }

    public int getDiastolic() {
        return this.diastolic;
    }

    public void setDiastolic(int diastolic) {
        this.diastolic = diastolic;
    }

    public int getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(int heartRate) {
        this.heartRate = heartRate;
    }

    public int getMeanArterialPressure() {
        return this.meanArterialPressure;
    }

    public void setMeanArterialPressure(int meanArterialPressure) {
        this.meanArterialPressure = meanArterialPressure;
    }

    public int getSystolic() {
        return this.systolic;
    }

    public void setSystolic(int systolic) {
        this.systolic = systolic;
    }

    public int getSystolicRelative() {
        return this.systolicRelative;
    }

    public void setSystolicRelative(int systolicRelative) {
        this.systolicRelative = systolicRelative;
    }
}

