/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.bloodpressure.view;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.soda.stepstone.backend.common.view.ChartMaker;
import org.eclipse.soda.stepstone.backend.data.bloodpressure.model.BloodPressureReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;

public class BloodPressureMarkupGenerator
implements IMarkupGenerator {
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public String[] dataTypeLabels() {
        return new String[]{"bloodPressure"};
    }

    private ChartMaker.DatedReading[][] getHeartRateDataFromReadings(BloodPressureReading[] readings) {
        ChartMaker.DatedReading[][] result = new ChartMaker.DatedReading[][]{new ChartMaker.DatedReading[readings.length]};
        int i = 0;
        while (i < readings.length) {
            result[0][i] = new ChartMaker.DatedIntReading((Date)readings[i].getMeasurementTimestamp(), readings[i].getHeartRate());
            ++i;
        }
        return result;
    }

    private ChartMaker.DatedReading[][] getPressureDataFromReadings(BloodPressureReading[] readings) {
        ChartMaker.DatedReading[][] result = new ChartMaker.DatedReading[][]{new ChartMaker.DatedReading[readings.length], new ChartMaker.DatedReading[readings.length]};
        int i = 0;
        while (i < readings.length) {
            result[0][i] = new ChartMaker.DatedIntReading((Date)readings[i].getMeasurementTimestamp(), readings[i].getSystolic());
            result[1][i] = new ChartMaker.DatedIntReading((Date)readings[i].getMeasurementTimestamp(), readings[i].getDiastolic());
            ++i;
        }
        return result;
    }

    public String markup(String patientId, String displayType) throws MarkupGeneratorException {
        BloodPressureReading[] readings;
        StringWriter out = new StringWriter();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            readings = patientId == null ? BloodPressureReading.getAllBloodPressureReadings(conn) : BloodPressureReading.getAllBloodPressureReadingsForId(conn, patientId);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        out.write("<!-- bloodPressure -->\n");
        if (displayType == null || displayType.equals("rawData")) {
            out.write("<script type=\"text/javascript\">\n");
            out.write("view = {cells: [[{name: 'Patient Id', width: '200px', field: 'PatientId'}, \n\t\t{name: 'Timestamp', width: '200px', field:'Timestamp'}, \n\t\t{name: 'Systolic', width: '100px', field:'Systolic'}, \n\t\t{name: 'Diastolic', width: '100px', field:'Diastolic'}, \n\t\t{name: 'Heart Rate', width: '100px', field:'Heartrate'}]] \n};\n");
            out.write("layout = [ view ];\n");
            out.write("</script>\n");
            out.write("<div dojoType=\"dojox.data.HtmlTableStore\" tableId=\"readingTable\" jsId=\"tableStore\"></div>\n");
            out.write("<div dojoType=\"dojox.grid.data.DojoData\" jsId=\"model\" rowsPerPage=\"20\" store=\"tableStore\" query=\"{}\"></div>\n");
            out.write("<table id=\"readingTable\" dojoType=\"dojox.Grid\" model=\"model\" structure=\"layout\" style=\"height: 400px;\">\n");
            out.write("<thead>\n");
            out.write("\t<tr>\n");
            out.write("     <th>PatientId</th>\n");
            out.write("\t\t<th>Timestamp</th>\n");
            out.write("\t\t<th>Systolic</th>\n");
            out.write("\t\t<th>Diastolic</th>\n");
            out.write("\t\t<th>Heartrate</th>\n");
            out.write("\t</tr>\n");
            out.write("</thead>\n");
            out.write("<tbody>\n");
            int i = 0;
            while (i < readings.length) {
                out.write("<tr>\n");
                out.write("<td>" + readings[i].getPatientId() + "</td>\n");
                out.write("<td>" + readings[i].getMeasurementTimestamp().toString() + "</td>\n");
                out.write("<td>" + Integer.toString(readings[i].getSystolic()) + "</td>\n");
                out.write("<td>" + Integer.toString(readings[i].getDiastolic()) + "</td>\n");
                out.write("<td>" + Integer.toString(readings[i].getHeartRate()) + "</td>\n");
                out.write("</tr>\n");
                ++i;
            }
            out.write("</tbody>\n");
            out.write("</table>\n");
        } else if (displayType.equals("chartPressure")) {
            out.write(String.valueOf(ChartMaker.chart((ChartMaker.DatedReading[][])this.getPressureDataFromReadings(readings), (int)1, (Number)new Integer(System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.warn", "140")), (Number)new Integer(System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.alert", "160")))) + "\n");
        } else if (displayType.equals("setAlerts")) {
            out.write("<button>Import Doctor Recommended Values</button>");
            out.write("<form name=\"alertForm\" method=\"post\">");
            out.write("<div>");
            out.write("<label for=\"warn\">Systolic Warning Level</label>");
            out.write("<input id=\"warn\" name = \"warn\" type=\"text\" value=\"" + System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.warn", "140") + "\" />");
            out.write("</div>");
            out.write("<div>");
            out.write("<label for=\"critical\">Systolic Critical Level</label>");
            out.write("<input id=\"critical\" name=\"critical\" type=\"text\" value=\"" + System.getProperty("org.eclipse.soda.stepstone.backend.data.bloodpressure.systolic.alert", "160") + "\" />");
            out.write("</div>");
            out.write("<input type=\"submit\" value=\"Apply Changes\" />");
            out.write("</form>");
        } else {
            out.write(String.valueOf(ChartMaker.chart((ChartMaker.DatedReading[][])this.getHeartRateDataFromReadings(readings), (int)1, null, null)) + "\n");
        }
        return out.toString();
    }

    public String[] allPatientIds() throws MarkupGeneratorException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            BloodPressureReading[] readings = BloodPressureReading.getAllBloodPressureReadings(conn);
            int i = 0;
            while (i < readings.length) {
                idSet.add(readings[i].getPatientId());
                ++i;
            }
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        return idSet.toArray(new String[0]);
    }
}

