/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox.communications;

import java.text.ParseException;
import org.eclipse.soda.stepstone.backend.common.communications.GenericMessageParser;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.data.pulseox.model.PulseOxReading;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;

public class PulseOxMessageParser
extends GenericMessageParser
implements IDataMessageParser {
    private static final int NUMOFPARAMS = 3;

    public GenericReading getNewComponentReading() {
        return new PulseOxReading();
    }

    public GenericReading parseDataMessage(String messageValue) throws ParseException {
        try {
            PulseOxReading reading = new PulseOxReading();
            String[] subMessages = messageValue.split("\\|");
            if (subMessages.length != 3) {
                throw new ParseException("Invalid Pulse Oximeter Reading", 0);
            }
            reading.setHeartRate(Integer.parseInt(subMessages[0]));
            reading.setSpO2(Integer.parseInt(subMessages[1]));
            return reading;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid Pulse Oximeter Reading", 0);
        }
    }
}

