/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox;

import org.eclipse.soda.stepstone.backend.data.pulseox.communications.PulseOxMessageParser;
import org.eclipse.soda.stepstone.backend.data.pulseox.model.PulseOxReading;
import org.eclipse.soda.stepstone.backend.data.pulseox.view.PulseOxMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.database.StringWithLength;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;

public class PulseOxComponent
implements IDataComponent {
    private PulseOxMarkupGenerator markupGenerator;
    private IDatabaseService dbService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
        if (this.markupGenerator != null) {
            this.markupGenerator.unbind();
        }
        this.markupGenerator = null;
    }

    public IDataMessageParser getMessageParser() {
        return new PulseOxMessageParser();
    }

    public IMarkupGenerator getMarkupGenerator() {
        if (this.markupGenerator == null) {
            this.markupGenerator = new PulseOxMarkupGenerator();
            this.markupGenerator.bind(this.dbService);
        }
        return this.markupGenerator;
    }

    public String getMessageTypeTag() {
        return "pulseOximeter";
    }

    public String getServletTag() {
        return "pulseOx";
    }

    public String getDeviceName() {
        return "Pulse Oximeter";
    }

    public static void createTable(IDatabaseConnection conn) throws StepstoneDatabaseException {
        if (conn.tableExists("pulse_oximeter")) {
            return;
        }
        String[] fieldNames = new String[]{"MEASUREMENT_TIMESTAMP", "PATIENT_ID", "SPO2", "HEART_RATE"};
        Object[] objectArray = new Object[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        objectArray[1] = new StringWithLength(10);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[2] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[3] = clazz3;
        Object[] types = objectArray;
        conn.createTable("pulse_oximeter", fieldNames, types);
    }

    public boolean isPatientViewable() {
        return true;
    }

    public IDataObject[] getAllReadingsForPatient(String id) {
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            return PulseOxReading.getAllPulseOxReadingsForId(conn, id);
        }
        catch (StepstoneDatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

