/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class PulseOxReading
extends GenericReading
implements IDataObject {
    public int heartRate;
    public int spO2;
    public int[] pleth;

    public static PulseOxReading[] getAllPulseOxReadingsForId(IDatabaseConnection c, String id) throws StepstoneDatabaseException {
        List readings = c.getReadings("pulse_oximeter", "PATIENT_ID", (Object)id, "MEASUREMENT_TIMESTAMP", 100);
        return PulseOxReading.convertFromList(readings);
    }

    public static PulseOxReading[] getAllPulseOxReadings(IDatabaseConnection c) throws StepstoneDatabaseException {
        List readings = c.getReadings("pulse_oximeter", null, null, "MEASUREMENT_TIMESTAMP", 100);
        return PulseOxReading.convertFromList(readings);
    }

    private static PulseOxReading[] convertFromList(List readings) {
        Iterator it = readings.iterator();
        ArrayList<PulseOxReading> readingsList = new ArrayList<PulseOxReading>();
        while (it.hasNext()) {
            readingsList.add(new PulseOxReading((Map)it.next()));
        }
        return readingsList.toArray(new PulseOxReading[0]);
    }

    public PulseOxReading(Map m) {
        super(m);
        this.heartRate = (Integer)m.get("HEART_RATE");
        this.spO2 = (Integer)m.get("SPO2");
    }

    public PulseOxReading() {
    }

    protected Map getMap() {
        Map map = super.getMap();
        map.put("HEART_RATE", new Integer(this.heartRate));
        map.put("SPO2", new Integer(this.spO2));
        return map;
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("pulse_oximeter", this.getMap());
    }

    public int[] getPleth() {
        return this.pleth;
    }

    public void setPleth(int[] pleth) {
        this.pleth = pleth;
    }

    public int getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(int heartRate) {
        this.heartRate = heartRate;
    }

    public int getSpO2() {
        return this.spO2;
    }

    public void setSpO2(int spO2) {
        this.spO2 = spO2;
    }
}

