/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox.view;

import java.io.StringWriter;
import org.eclipse.soda.stepstone.backend.data.pulseox.model.PulseOxReading;
import org.eclipse.soda.stepstone.backend.devices.view.DeviceDataHTML;

public class PulseOxDataHTML
extends DeviceDataHTML {
    private PulseOxReading[] readings;

    public PulseOxDataHTML(StringWriter out, PulseOxReading[] readings) {
        super(out);
        this.readings = readings;
        this.writeData();
    }

    protected void writeData() {
        this.out.write("<!-- pulseOx -->\n");
        super.writeData();
    }

    protected void writeFields() {
        this.out.write("<thead>\n");
        this.out.write("\t<tr>\n");
        this.out.write("     <th>PatientId</th>");
        this.out.write("\t\t<th>Timestamp</th>\n");
        this.out.write("\t\t<th>SpO2</th>\n");
        this.out.write("\t\t<th>Heartrate</th>\n");
        this.out.write("\t</tr>\n");
        this.out.write("</thead>\n");
    }

    protected void writeReadings() {
        this.out.write("<tbody>\n");
        int i = 0;
        while (i < this.readings.length) {
            this.out.write("<tr>\n");
            this.out.write("<td>" + this.readings[i].getPatientId() + "</td>\n");
            this.out.write("<td>" + this.readings[i].getMeasurementTimestamp().toString() + "</td>\n");
            this.out.write("<td>" + Integer.toString(this.readings[i].getSpO2()) + "</td>\n");
            this.out.write("<td>" + Integer.toString(this.readings[i].getHeartRate()) + "</td>\n");
            this.out.write("</tr>\n");
            ++i;
        }
        this.out.write("</tbody>\n");
    }
}

