/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox.view;

import java.io.StringWriter;
import org.eclipse.soda.stepstone.backend.data.pulseox.model.PulseOxReading;
import org.eclipse.soda.stepstone.backend.devices.view.DeviceDataJSON;

public class PulseOxDataJSON
extends DeviceDataJSON {
    private PulseOxReading[] readings;

    public PulseOxDataJSON(StringWriter out, PulseOxReading[] readings) {
        super(out);
        this.readings = readings;
        this.writeData();
    }

    protected void writeFields() {
        super.writeFields();
        this.out.write("\t\t[\"PatientId\", \"TimeStamp\", \"SpO2\",\"Heartrate\"],\n");
    }

    protected void writeReadings() {
        super.writeReadings();
        int i = 0;
        while (i < this.readings.length) {
            this.out.write("\t\t\t{\"PatientId\": \"" + this.readings[i].getPatientId() + "\", ");
            this.out.write("\"TimeStamp\": \"" + this.readings[i].getMeasurementTimestamp().toString() + "\", ");
            this.out.write("\"SpO2\": \"" + Integer.toString(this.readings[i].getSpO2()) + "\", ");
            this.out.write("\"Heartrate\": \"" + Integer.toString(this.readings[i].getHeartRate()) + "\"}");
            if (i < this.readings.length - 1) {
                this.out.write(",\n");
            } else {
                this.out.write("\n");
            }
            ++i;
        }
        this.out.write("\t\t]\n");
    }
}

