/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.pulseox.view;

import java.io.StringWriter;
import java.util.HashSet;
import org.eclipse.soda.stepstone.backend.data.pulseox.model.PulseOxReading;
import org.eclipse.soda.stepstone.backend.data.pulseox.view.PulseOxDataHTML;
import org.eclipse.soda.stepstone.backend.data.pulseox.view.PulseOxDataJSON;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;

public class PulseOxMarkupGenerator
implements IMarkupGenerator {
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public String[] dataTypeLabels() {
        return new String[]{"pulseOx"};
    }

    public String markup(String patientId, String mimeType) throws MarkupGeneratorException {
        PulseOxReading[] readings;
        StringWriter out = new StringWriter();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            readings = patientId == null ? PulseOxReading.getAllPulseOxReadings(conn) : PulseOxReading.getAllPulseOxReadingsForId(conn, patientId);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        if (mimeType.equals("application/json")) {
            return new PulseOxDataJSON(out, readings).getData();
        }
        return new PulseOxDataHTML(out, readings).getData();
    }

    public String[] allPatientIds() throws MarkupGeneratorException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            PulseOxReading[] readings = PulseOxReading.getAllPulseOxReadings(conn);
            int i = 0;
            while (i < readings.length) {
                idSet.add(readings[i].getPatientId());
                ++i;
            }
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        return idSet.toArray(new String[0]);
    }
}

