/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.temperature.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class TemperatureReading
extends GenericReading
implements IDataObject {
    private double temperature;

    public static TemperatureReading[] getAllTemperatureReadingsForId(IDatabaseConnection c, String id) throws StepstoneDatabaseException {
        List readings = c.getReadings("temperature", "PATIENT_ID", (Object)id, "MEASUREMENT_TIMESTAMP", 100);
        return TemperatureReading.convertFromList(readings);
    }

    public static TemperatureReading[] getAllTemperatureReadings(IDatabaseConnection c) throws StepstoneDatabaseException {
        List readings = c.getReadings("temperature", null, null, "MEASUREMENT_TIMESTAMP", 100);
        return TemperatureReading.convertFromList(readings);
    }

    private static TemperatureReading[] convertFromList(List readings) {
        Iterator it = readings.iterator();
        ArrayList<TemperatureReading> readingsList = new ArrayList<TemperatureReading>();
        while (it.hasNext()) {
            readingsList.add(new TemperatureReading((Map)it.next()));
        }
        return readingsList.toArray(new TemperatureReading[0]);
    }

    public TemperatureReading(Map m) {
        super(m);
        this.temperature = (Double)m.get("TEMPERATURE");
    }

    public TemperatureReading() {
    }

    protected Map getMap() {
        Map map = super.getMap();
        map.put("TEMPERATURE", new Double(this.temperature));
        return map;
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("temperature", this.getMap());
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

