/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.temperature.view;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.soda.stepstone.backend.common.view.ChartMaker;
import org.eclipse.soda.stepstone.backend.data.temperature.model.TemperatureReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;

public class TemperatureMarkupGenerator
implements IMarkupGenerator {
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public String[] dataTypeLabels() {
        return new String[]{"temperature"};
    }

    private ChartMaker.DatedDoubleReading[][] getTemperatureDataFromReadings(TemperatureReading[] readings) {
        ChartMaker.DatedDoubleReading[][] result = new ChartMaker.DatedDoubleReading[][]{new ChartMaker.DatedDoubleReading[readings.length]};
        int i = 0;
        while (i < readings.length) {
            result[0][i] = new ChartMaker.DatedDoubleReading((Date)readings[i].getMeasurementTimestamp(), readings[i].getTemperature());
            ++i;
        }
        return result;
    }

    public String markup(String patientId, String displayType) throws MarkupGeneratorException {
        TemperatureReading[] readings;
        StringWriter out = new StringWriter();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            readings = patientId == null ? TemperatureReading.getAllTemperatureReadings(conn) : TemperatureReading.getAllTemperatureReadingsForId(conn, patientId);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        out.write("<!-- temperature -->\n");
        if (displayType == null || displayType.equals("rawData")) {
            out.write("<script type='text/javascript'>");
            out.write("var view = {cells: [[{name: 'Patient Id', width: '200px', field: 'PatientId'}, \n\t\t{name: 'Timestamp', width: '200px', field:'Timestamp'}, \n\t\t{name: 'Temperature (C)', width: '200px', field:'Temperature'}]] \n};\nvar layout = [ view ];\n");
            out.write("</script>");
            out.write("<div dojoType=\"dojox.data.HtmlTableStore\" tableId=\"readingTable\" jsId=\"tableStore\"></div>\n");
            out.write("<div dojoType=\"dojox.grid.data.DojoData\" jsId=\"model\" rowsPerPage=\"20\" store=\"tableStore\" query=\"{}\"></div>\n");
            out.write("<table id=\"readingTable\" dojoType=\"dojox.Grid\" model=\"model\" structure=\"layout\" style=\"height: 400px;\">\n");
            out.write("<thead>\n");
            out.write("\t<tr>\n");
            out.write("     <th>PatientId</th>");
            out.write("\t\t<th>Timestamp</th>\n");
            out.write("\t\t<th>Temperature</th>\n");
            out.write("\t</tr>\n");
            out.write("</thead>\n");
            out.write("<tbody>\n");
            int i = 0;
            while (i < readings.length) {
                out.write("<tr>\n");
                out.write("<td>" + readings[i].getPatientId() + "</td>\n");
                out.write("<td>" + readings[i].getMeasurementTimestamp().toString() + "</td>\n");
                out.write("<td>" + Double.toString(readings[i].getTemperature()) + "</td>\n");
                out.write("</tr>\n");
                ++i;
            }
            out.write("</tbody>\n");
            out.write("</table>\n");
        } else {
            out.write(String.valueOf(ChartMaker.chart((ChartMaker.DatedReading[][])this.getTemperatureDataFromReadings(readings), (int)100, null, null)) + "\n");
        }
        return out.toString();
    }

    public String[] allPatientIds() throws MarkupGeneratorException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            TemperatureReading[] readings = TemperatureReading.getAllTemperatureReadings(conn);
            int i = 0;
            while (i < readings.length) {
                idSet.add(readings[i].getPatientId());
                ++i;
            }
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        return idSet.toArray(new String[0]);
    }
}

