/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.temperature;

import org.eclipse.soda.stepstone.backend.data.temperature.communications.TemperatureMessageParser;
import org.eclipse.soda.stepstone.backend.data.temperature.model.TemperatureReading;
import org.eclipse.soda.stepstone.backend.data.temperature.view.TemperatureMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.database.StringWithLength;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;

public class TemperatureComponent
implements IDataComponent {
    private TemperatureMarkupGenerator markupGenerator;
    private IDatabaseService dbService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
        if (this.markupGenerator != null) {
            this.markupGenerator.unbind();
        }
        this.markupGenerator = null;
    }

    public IDataMessageParser getMessageParser() {
        return new TemperatureMessageParser();
    }

    public IMarkupGenerator getMarkupGenerator() {
        if (this.markupGenerator == null) {
            this.markupGenerator = new TemperatureMarkupGenerator();
            this.markupGenerator.bind(this.dbService);
        }
        return this.markupGenerator;
    }

    public String getMessageTypeTag() {
        return "temperature";
    }

    public String getServletTag() {
        return "temperature";
    }

    public String getDeviceName() {
        return "Temperature";
    }

    public static void createTable(IDatabaseConnection conn) throws StepstoneDatabaseException {
        if (conn.tableExists("temperature")) {
            return;
        }
        String[] fieldNames = new String[]{"MEASUREMENT_TIMESTAMP", "PATIENT_ID", "TEMPERATURE"};
        Object[] objectArray = new Object[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        objectArray[1] = new StringWithLength(10);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[2] = clazz2;
        Object[] types = objectArray;
        conn.createTable("temperature", fieldNames, types);
    }

    public boolean isPatientViewable() {
        return true;
    }

    public IDataObject[] getAllReadingsForPatient(String id) {
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            return TemperatureReading.getAllTemperatureReadingsForId(conn, id);
        }
        catch (StepstoneDatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

