/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.temperature.view;

import java.io.StringWriter;
import org.eclipse.soda.stepstone.backend.data.temperature.model.TemperatureReading;
import org.eclipse.soda.stepstone.backend.devices.view.DeviceDataJSON;

public class TemperatureDataJSON
extends DeviceDataJSON {
    private TemperatureReading[] readings;

    public TemperatureDataJSON(StringWriter out, TemperatureReading[] readings) {
        super(out);
        this.readings = readings;
        this.writeData();
    }

    protected void writeFields() {
        super.writeFields();
        this.out.write("\t\t[\"PatientId\", \"TimeStamp\", \"Temperature\"],\n");
    }

    protected void writeReadings() {
        super.writeReadings();
        int i = 0;
        while (i < this.readings.length) {
            this.out.write("\t\t\t{\"PatientId\": \"" + this.readings[i].getPatientId() + "\", ");
            this.out.write("\"TimeStamp\": \"" + this.readings[i].getMeasurementTimestamp().toString() + "\", ");
            this.out.write("\"Temperature\": \"" + Double.toString(this.readings[i].getTemperature()) + "\"}");
            if (i < this.readings.length - 1) {
                this.out.write(",\n");
            } else {
                this.out.write("\n");
            }
            ++i;
        }
        this.out.write("\t\t]\n");
    }
}

