/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.weight.view;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.soda.stepstone.backend.common.view.ChartMaker;
import org.eclipse.soda.stepstone.backend.data.weight.model.WeightReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.MarkupGeneratorException;

public class WeightMarkupGenerator
implements IMarkupGenerator {
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    public void unbind() {
        this.dbService = null;
    }

    public String[] dataTypeLabels() {
        return new String[]{"weight"};
    }

    private ChartMaker.DatedReading[][] getWeightDataFromReadings(WeightReading[] readings) {
        ChartMaker.DatedReading[][] result = new ChartMaker.DatedReading[][]{new ChartMaker.DatedReading[readings.length]};
        int i = 0;
        while (i < readings.length) {
            result[0][i] = new ChartMaker.DatedIntReading((Date)readings[i].getMeasurementTimestamp(), readings[i].getWeight());
            ++i;
        }
        return result;
    }

    public String markup(String patientId, String displayType) throws MarkupGeneratorException {
        WeightReading[] readings;
        StringWriter out = new StringWriter();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            readings = patientId == null ? WeightReading.getAllWeightReadings(conn) : WeightReading.getAllWeightReadingsForId(conn, patientId);
            conn.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        out.write("<!-- weight -->\n");
        if (displayType == null || displayType.equals("rawData")) {
            out.write("<script type='text/javascript'>");
            out.write("var view = {cells: [[{name: 'Patient Id', width: '200px', field: 'PatientId'}, \n\t\t{name: 'Timestamp', width: '300px', field:'Timestamp'}, \n\t\t{name: 'Weight (Kg)', width: '300px', field:'Weight'}]] \n};\n");
            out.write("var layout = [ view ];\n");
            out.write("</script>");
            out.write("<div dojoType=\"dojox.data.HtmlTableStore\" tableId=\"readingTable\" jsId=\"tableStore\"></div>\n");
            out.write("<div dojoType=\"dojox.grid.data.DojoData\" jsId=\"model\" rowsPerPage=\"20\" store=\"tableStore\" query=\"{}\"></div>\n");
            out.write("<table id=\"readingTable\" dojoType=\"dojox.Grid\" model=\"model\" structure=\"layout\" style=\"height: 400px;\" >\n");
            out.write("<thead>\n");
            out.write("\t<tr>\n");
            out.write("     <th>PatientId</th>");
            out.write("\t\t<th>Timestamp</th>\n");
            out.write("\t\t<th>Weight</th>\n");
            out.write("\t</tr>\n");
            out.write("</thead>\n");
            out.write("<tbody>\n");
            int i = 0;
            while (i < readings.length) {
                out.write("<tr>\n");
                out.write("<td>" + readings[i].getPatientId() + "</td>\n");
                out.write("<td>" + readings[i].getMeasurementTimestamp().toString() + "</td>\n");
                out.write("<td>" + Double.toString((double)readings[i].getWeight() / 100.0) + "</td>\n");
                out.write("</tr>\n");
                ++i;
            }
            out.write("</tbody>\n");
            out.write("</table>\n");
        } else {
            out.write(String.valueOf(ChartMaker.chart((ChartMaker.DatedReading[][])this.getWeightDataFromReadings(readings), (int)100, null, null)) + "\n");
        }
        return out.toString();
    }

    public String[] allPatientIds() throws MarkupGeneratorException {
        HashSet<String> idSet = new HashSet<String>();
        try {
            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
            WeightReading[] readings = WeightReading.getAllWeightReadings(conn);
            int i = 0;
            while (i < readings.length) {
                idSet.add(readings[i].getPatientId());
                ++i;
            }
        }
        catch (StepstoneDatabaseException e) {
            throw new MarkupGeneratorException((Exception)((Object)e));
        }
        return idSet.toArray(new String[0]);
    }
}

