/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.weight.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.common.model.GenericReading;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class WeightReading
extends GenericReading
implements IDataObject {
    private int weight;

    public static WeightReading[] getAllWeightReadingsForId(IDatabaseConnection c, String id) throws StepstoneDatabaseException {
        List readings = c.getReadings("weight", "PATIENT_ID", (Object)id, "MEASUREMENT_TIMESTAMP", 100);
        return WeightReading.convertFromList(readings);
    }

    public static WeightReading[] getAllWeightReadings(IDatabaseConnection c) throws StepstoneDatabaseException {
        List readings = c.getReadings("weight", null, null, "MEASUREMENT_TIMESTAMP", 100);
        return WeightReading.convertFromList(readings);
    }

    private static WeightReading[] convertFromList(List readings) {
        Iterator it = readings.iterator();
        ArrayList<WeightReading> readingsList = new ArrayList<WeightReading>();
        while (it.hasNext()) {
            readingsList.add(new WeightReading((Map)it.next()));
        }
        return readingsList.toArray(new WeightReading[0]);
    }

    public WeightReading(Map m) {
        super(m);
        this.weight = (Integer)m.get("WEIGHT");
    }

    public WeightReading() {
    }

    protected Map getMap() {
        Map map = super.getMap();
        map.put("WEIGHT", new Integer(this.weight));
        return map;
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("weight", this.getMap());
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

