/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.weight.view;

import java.io.StringWriter;
import org.eclipse.soda.stepstone.backend.data.weight.model.WeightReading;
import org.eclipse.soda.stepstone.backend.devices.view.DeviceDataHTML;

public class WeightDataHTML
extends DeviceDataHTML {
    private WeightReading[] readings;

    public WeightDataHTML(StringWriter out, WeightReading[] readings) {
        super(out);
        this.readings = readings;
        this.writeData();
    }

    public void writeData() {
        this.out.write("<!-- weight -->\n");
        super.writeData();
    }

    public void writeFields() {
        this.out.write("<thead>\n");
        this.out.write("\t<tr>\n");
        this.out.write("<th>PatientId</th>");
        this.out.write("<th>Timestamp</th>\n");
        this.out.write("<th>Weight</th>\n");
        this.out.write("\t</tr>\n");
        this.out.write("</thead>\n");
    }

    public void writeReadings() {
        this.out.write("<tbody>\n");
        int i = 0;
        while (i < this.readings.length) {
            this.out.write("<tr>\n");
            this.out.write("<td>" + this.readings[i].getPatientId() + "</td>\n");
            this.out.write("<td>" + this.readings[i].getMeasurementTimestamp().toString() + "</td>\n");
            this.out.write("<td>" + Double.toString((double)this.readings[i].getWeight() / 100.0) + "</td>\n");
            this.out.write("</tr>\n");
            ++i;
        }
        this.out.write("</tbody>\n");
    }
}

