/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.data.weight.view;

import java.io.StringWriter;
import org.eclipse.soda.stepstone.backend.data.weight.model.WeightReading;
import org.eclipse.soda.stepstone.backend.devices.view.DeviceDataJSON;

public class WeightDataJSON
extends DeviceDataJSON {
    private WeightReading[] readings;

    public WeightDataJSON(StringWriter out, WeightReading[] readings) {
        super(out);
        this.readings = readings;
        this.writeData();
    }

    protected void writeFields() {
        super.writeFields();
        this.out.write("\t\t[\"PatientId\", \"TimeStamp\", \"Weight\"],");
    }

    protected void writeReadings() {
        super.writeReadings();
        int i = 0;
        while (i < this.readings.length) {
            this.out.write("\t\t\t{\"PatientId\": \"" + this.readings[i].getPatientId() + "\", ");
            this.out.write("\"TimeStamp\": \"" + this.readings[i].getMeasurementTimestamp().toString() + "\", ");
            this.out.write("\"Weight\": \"" + Double.toString((double)this.readings[i].getWeight() / 100.0) + "\"}");
            if (i < this.readings.length - 1) {
                this.out.write(",");
            } else {
                this.out.write("");
            }
            ++i;
        }
        this.out.write("\t\t]");
    }
}

