/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.devices;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.stepstone.backend.devices.bundle.Activator;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.eclipse.soda.stepstone.backend.service.device.IMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.device.IRepositoryClientService;

public class DeviceService
implements IDeviceService {
    private List dataComponents = new ArrayList();

    public void registerDataComponent(IDataComponent component) {
        if (component.isPatientViewable()) {
            this.dataComponents.add(0, component);
        } else {
            this.dataComponents.add(component);
        }
    }

    public void deregisterDataComponent(IDataComponent component) {
        this.dataComponents.remove(component);
    }

    public IDataMessageParser getDataMessageParserForReadingType(String tag) {
        Iterator i = this.dataComponents.iterator();
        while (i.hasNext()) {
            IDataComponent thisComponent = (IDataComponent)i.next();
            String componentTag = thisComponent.getMessageTypeTag();
            if (!componentTag.equals(tag)) continue;
            return thisComponent.getMessageParser();
        }
        IRepositoryClientService bundleRepositoryService = Activator.getRepositoryClientService();
        if (bundleRepositoryService != null && bundleRepositoryService.installProvider(tag)) {
            i = this.dataComponents.iterator();
            while (i.hasNext()) {
                IDataComponent thisComponent = (IDataComponent)i.next();
                String componentTag = thisComponent.getMessageTypeTag();
                if (!componentTag.equals(tag)) continue;
                return thisComponent.getMessageParser();
            }
        }
        return null;
    }

    public IMarkupGenerator getMarkupGeneratorForTag(String tag) {
        Iterator i = this.dataComponents.iterator();
        while (i.hasNext()) {
            IMarkupGenerator marker = ((IDataComponent)i.next()).getMarkupGenerator();
            if (marker == null) continue;
            String[] labels = marker.dataTypeLabels();
            int j = 0;
            while (j < labels.length) {
                if (labels[j].equals(tag)) {
                    return marker;
                }
                ++j;
            }
        }
        return null;
    }

    public IDataComponent[] getDataComponents() {
        return this.dataComponents.toArray(new IDataComponent[0]);
    }
}

