/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.devices.view;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;

public class DeviceServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private IDeviceService deviceService;

    public void bind(IDeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public void unbind() {
        this.deviceService = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json;charset=ISO-8859-1");
        String generatedDeviceList = this.buildDeviceList(this.deviceService.getDataComponents());
        resp.getOutputStream().println(generatedDeviceList);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private String buildDeviceList(IDataComponent[] dataComponents) {
        String deviceList = "{\"devices\": [";
        int i = 0;
        while (i < dataComponents.length) {
            if (dataComponents[i].getDeviceName() != null) {
                if (i > 0) {
                    deviceList = String.valueOf(deviceList) + ",";
                }
                deviceList = String.valueOf(deviceList) + "{\"deviceName\":\"" + dataComponents[i].getDeviceName() + "\", \"url\":\"" + dataComponents[i].getServletTag() + "\"}";
            }
            ++i;
        }
        deviceList = String.valueOf(deviceList) + "]}";
        return deviceList;
    }
}

