/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients;

import javax.servlet.Servlet;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.eclipse.equinox.jsp.jasper.JspServlet;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.eclipse.soda.stepstone.backend.patients.PatientComponent;
import org.eclipse.soda.stepstone.backend.patients.PatientService;
import org.eclipse.soda.stepstone.backend.patients.service.IPatientService;
import org.eclipse.soda.stepstone.backend.patients.view.PatientServlet;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataComponent;
import org.eclipse.soda.stepstone.backend.service.uiregistry.IUIExtension;
import org.eclipse.soda.stepstone.backend.service.uiregistry.IUIExtensionRegistry;
import org.eclipse.soda.stepstone.backend.service.uiregistry.UIExtension;
import org.osgi.service.http.HttpService;

public class Activator
extends BaseBundleActivator {
    private static final String UTILITY_KEY;
    private IUIExtensionRegistry registry;
    private HttpService httpService;
    private IDatabaseService dbService;
    private IGlobalStoreService globalStoreService;
    private PatientServlet patientServlet;
    private PatientService patientService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.stepstone.backend.patients.Activator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UTILITY_KEY = clazz.getName();
    }

    protected IDataComponent getComponent() {
        return new PatientComponent();
    }

    protected void activate() {
        this.dbService = this.getDatabaseService();
        this.globalStoreService = this.getGlobalStoreService();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.httpService = (HttpService)this.getImportedService(clazz.getName());
        try {
            IDatabaseConnection dc = this.dbService.getDatabaseConnection();
            this.createTable(dc);
            dc.cleanUp();
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logWarning((String)"Problem creating database table for patients", (Throwable)e);
        }
        this.registry = (IUIExtensionRegistry)this.getImportedService(IUIExtensionRegistry.SERVICE_NAME);
        UIExtension ex = new UIExtension("Patients", "index?url=patient-servlet");
        this.registry.addUtility(UTILITY_KEY, (IUIExtension)ex);
        this.patientService = new PatientService();
        this.patientService.bind(this.dbService);
        this.addExportedService(IPatientService.SERVICE_NAME, this.patientService, null);
        this.patientServlet = new PatientServlet();
        this.patientServlet.bind(this.dbService, this.globalStoreService, this.patientService);
        try {
            ContextPathServletAdaptor adaptedJspServlet = new ContextPathServletAdaptor((Servlet)new JspServlet(this.getBundle(), "/webFiles"), "/");
            this.httpService.registerServlet("/patient-servlet", (Servlet)this.patientServlet, null, null);
            this.httpService.registerServlet("/patient/*.jsp", (Servlet)adaptedJspServlet, null, null);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deactivate() {
        this.registry.removeUtility(UTILITY_KEY);
        this.httpService.unregister("/patient-servlet");
        this.httpService.unregister("/patient/*.jsp");
        this.patientServlet.unbind();
        this.removeExportedService(IPatientService.SERVICE_NAME);
        this.patientService.unbind();
        super.deactivate();
    }

    protected String[] getImportedServiceNames() {
        String[] stringArray = new String[4];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.http.HttpService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        stringArray[1] = IDatabaseService.SERVICE_NAME;
        stringArray[2] = IUIExtensionRegistry.SERVICE_NAME;
        stringArray[3] = IGlobalStoreService.SERVICE_NAME;
        return stringArray;
    }

    protected String[] getExportedServiceNames() {
        return new String[]{IPatientService.SERVICE_NAME};
    }

    protected void createTable(IDatabaseConnection dc) throws StepstoneDatabaseException {
        PatientComponent.createTable(dc);
    }

    private IDatabaseService getDatabaseService() {
        return (IDatabaseService)this.getImportedService(IDatabaseService.SERVICE_NAME);
    }

    private IGlobalStoreService getGlobalStoreService() {
        return (IGlobalStoreService)this.getImportedService(IGlobalStoreService.SERVICE_NAME);
    }
}

