/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.patients.service.IPatientService;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;

public class PatientService
implements IPatientService {
    private IDatabaseService dbService;

    public void bind(IDatabaseService dbService) {
        this.dbService = dbService;
    }

    protected void unbind() {
        this.dbService = null;
    }

    public Patient[] getAllPatients() throws StepstoneDatabaseException {
        IDatabaseConnection conn = this.dbService.getDatabaseConnection();
        List patients = conn.getReadings("patient", null, null, null);
        conn.cleanUp();
        return PatientService.convertFromList(patients);
    }

    public Patient getPatientWithId(String id) throws StepstoneDatabaseException {
        IDatabaseConnection conn = this.dbService.getDatabaseConnection();
        List patients = conn.getReadings("patient", "PATIENT_ID", (Object)id, null);
        conn.cleanUp();
        if (patients.isEmpty()) {
            return null;
        }
        return new Patient((Map)patients.get(0));
    }

    public void deletePatientWithId(String id) throws StepstoneDatabaseException {
        IDatabaseConnection conn = this.dbService.getDatabaseConnection();
        conn.deleteItem("patient", "PATIENT_ID", (Object)id);
        conn.cleanUp();
    }

    private static Patient[] convertFromList(List patients) {
        Iterator it = patients.iterator();
        ArrayList<Patient> patientList = new ArrayList<Patient>();
        while (it.hasNext()) {
            patientList.add(new Patient((Map)it.next()));
        }
        return patientList.toArray(new Patient[0]);
    }
}

