/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.eclipse.soda.stepstone.backend.patients.PatientService;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;

public class PatientServlet
extends HttpServlet {
    private PatientService patientService;
    private IGlobalStoreService globalStore;
    private IDatabaseService dbService;
    private static final long serialVersionUID = 1L;

    public void bind(IDatabaseService dbService, IGlobalStoreService globalStoreService, PatientService patientService) {
        this.dbService = dbService;
        this.globalStore = globalStoreService;
        this.patientService = patientService;
    }

    public void unbind() {
        this.dbService = null;
        this.globalStore = null;
        this.patientService = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Patient[] patients;
        ServletException exception;
        block30: {
            resp.setContentType("text/html");
            exception = null;
            String action = req.getParameter("action");
            if (action != null) {
                String patientId;
                if (action.equals("add")) {
                    try {
                        if (this.patientService.getPatientWithId(req.getParameter("PATIENT_ID")) == null) {
                            Patient newPatient = new Patient();
                            newPatient.setId(req.getParameter("PATIENT_ID"));
                            newPatient.setFirstName(req.getParameter("FIRST_NAME"));
                            newPatient.setLastName(req.getParameter("LAST_NAME"));
                            newPatient.setAddressLine1(req.getParameter("address1"));
                            newPatient.setAddressLine2(req.getParameter("address2"));
                            newPatient.setDateOfBirth(this.makeDate(Integer.parseInt(req.getParameter("year")), Integer.parseInt(req.getParameter("month")), Integer.parseInt(req.getParameter("day"))));
                            if (req.getParameter("MALE").equals("true")) {
                                newPatient.setIsMale(true);
                            } else {
                                newPatient.setIsMale(false);
                            }
                            newPatient.setEthnicity(req.getParameter("ETHICITY"));
                            newPatient.setContactFirstName(req.getParameter("CONTACT_FIRST_NAME"));
                            newPatient.setContactLastName(req.getParameter("CONTACT_LAST_NAME"));
                            newPatient.setContactHomePhone(this.strip(req.getParameter("CONTACT_PHONE")));
                            newPatient.setContactCellPhone(this.strip(req.getParameter("CONTACT_CELL")));
                            newPatient.setContactCellCarrier(req.getParameter("CONTACT_CELL_CARRIER"));
                            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
                            newPatient.writeToDatabase(conn);
                            conn.cleanUp();
                            break block30;
                        }
                        exception = new ServletException("Patient " + req.getParameter("PATIENT_ID") + " already exists in the database");
                    }
                    catch (StepstoneDatabaseException e) {
                        exception = new ServletException((Throwable)e);
                    }
                } else if (action.equals("del")) {
                    patientId = req.getParameter("PATIENT_ID");
                    if (patientId != null && patientId != "") {
                        try {
                            this.patientService.deletePatientWithId(patientId);
                        }
                        catch (StepstoneDatabaseException e) {
                            exception = new ServletException("Error deleting patient", (Throwable)e);
                        }
                    }
                } else if (action.equals("toEdit")) {
                    String patientId2 = req.getParameter("PATIENT_ID");
                    try {
                        Patient patient = this.patientService.getPatientWithId(patientId2);
                        req.setAttribute("patient", (Object)patient);
                        this.setParams(req);
                        RequestDispatcher addPatientDispatcher = this.getServletContext().getRequestDispatcher("/patient/editPatient.jsp");
                        addPatientDispatcher.include((ServletRequest)req, (ServletResponse)resp);
                        return;
                    }
                    catch (StepstoneDatabaseException e) {
                        exception = new ServletException((Throwable)e);
                    }
                } else if (action.equals("edit")) {
                    patientId = req.getParameter("PATIENT_ID");
                    if (patientId != null && patientId != "") {
                        try {
                            Patient patient = this.patientService.getPatientWithId(patientId);
                            patient.setFirstName(req.getParameter("FIRST_NAME"));
                            patient.setLastName(req.getParameter("LAST_NAME"));
                            patient.setAddressLine1(req.getParameter("address1"));
                            patient.setAddressLine2(req.getParameter("address2"));
                            patient.setDateOfBirth(this.makeDate(Integer.parseInt(req.getParameter("year")), Integer.parseInt(req.getParameter("month")), Integer.parseInt(req.getParameter("day"))));
                            patient.setIsMale(Boolean.getBoolean(req.getParameter("MALE")));
                            patient.setEthnicity(req.getParameter("ETHICITY"));
                            patient.setContactFirstName(req.getParameter("CONTACT_FIRST_NAME"));
                            patient.setContactLastName(req.getParameter("CONTACT_LAST_NAME"));
                            patient.setContactHomePhone(req.getParameter("CONTACT_PHONE"));
                            patient.setContactCellPhone(req.getParameter("CONTACT_CELL"));
                            patient.setContactCellCarrier(req.getParameter("CONTACT_CELL_CARRIER"));
                            IDatabaseConnection conn = this.dbService.getDatabaseConnection();
                            patient.updateInDatabase(conn);
                            conn.cleanUp();
                        }
                        catch (StepstoneDatabaseException e) {
                            exception = new ServletException("Error Updating Patient", (Throwable)e);
                        }
                    }
                } else if (action.equals("view") && (patientId = req.getParameter("PATIENT_ID")) != null) {
                    try {
                        if (this.patientService.getPatientWithId(patientId) != null) {
                            this.globalStore.put("currentPatient", (Object)patientId);
                            PrintWriter out = resp.getWriter();
                            out.println("<script language=\"javascript\">");
                            out.println("function refresh()");
                            out.println("{ document.getElementById('reload_form').submit() }");
                            out.println("</script>");
                            out.println("</head>");
                            out.println("<body onload=\"refresh()\">");
                            out.println("<form id=\"reload_form\" action=\"index\"></form>");
                        }
                    }
                    catch (StepstoneDatabaseException e) {
                        exception = new ServletException("Error Updating Patient", (Throwable)e);
                    }
                }
            }
        }
        try {
            patients = this.patientService.getAllPatients();
        }
        catch (StepstoneDatabaseException e) {
            throw new ServletException("Error retrieving patient list", (Throwable)e);
        }
        req.setAttribute("patientList", Arrays.asList(patients));
        if (exception != null) {
            req.setAttribute("errorMsg", (Object)exception.getMessage());
        } else {
            req.setAttribute("errorMsg", (Object)new String());
        }
        this.setParams(req);
        RequestDispatcher addPatientDispatcher = this.getServletContext().getRequestDispatcher("/patient/patientTabs.jsp");
        addPatientDispatcher.include((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private Date makeDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return new Date(cal.getTimeInMillis());
    }

    private void setParams(HttpServletRequest request) {
        request.setAttribute("actionUrl", (Object)request.getRequestURL().toString());
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            request.setAttribute(paramName, (Object)request.getParameter(paramName));
        }
    }

    private String strip(String string) {
        String returnString = "";
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                returnString = String.valueOf(returnString) + c;
            }
            ++i;
        }
        return returnString;
    }
}

