<%@ page import="org.eclipse.soda.stepstone.backend.patients.Constants" %>
<%@page import="java.util.Calendar"%>

<jsp:useBean id="patient" type="org.eclipse.soda.stepstone.backend.patients.model.Patient" scope="request" />
<jsp:useBean id="actionUrl" type="java.lang.String" scope="request" />
<jsp:useBean id="url" type="java.lang.String" scope="request" />

<head>
	<script type="text/javascript">
		function checkForm(){
			var today = new Date();
			var dob = new Date();
			var year = document.getElementById("year").value;
			var month = document.getElementById("month").value - 1;
			var day = document.getElementById("day").value;
			dob.setFullYear(year,month,day);
			if(year!=null && month!=null && day!=null && month >= 0 && month < 12 && day > 0 && day < 32 && dob < today){
				return true;
			}
			else{
				alert("Please enter a valid date of birth");
			}
			return false;
		}
		function getDate(){
			var dob = new Date();
			dob.setTime(<%=patient.getDateOfBirth().getTime()%>);
			document.getElementById("year").value = dob.getFullYear();
			document.getElementById("month").value = numToString(dob.getMonth() + 1, 2);
			document.getElementById("day").value = 	numToString(dob.getDate(), 2);
		}
		/*Adds "0" prefix to number until it is desired length*/
		function numToString(num,length){
			var numString = new String(num);
			while(numString.length < length){
				numString = "0" + numString;
			}
			return numString;
		}
	</script>
</head>
<body onload="getDate()">
	<h2>Patient # <%=patient.getId()%></h2>
	<form name="editPatientForm" action="<%=actionUrl%>" method="post" onsubmit="return checkForm()">
		<div>
			<label for="fname">First Name</label> 
			<input type="text" id="fname" name="<%=Constants.PARAM_FIRST_NAME%>" 
					value="<%=patient.getFirstName()%>" /> 
			<label for="lname">Last Name</label> 
			<input type="text" id="lname" name="<%=Constants.PARAM_LAST_NAME%>" 
					value="<%=patient.getLastName()%>" />
		</div>
		
		<label for="address">Address</label>
		<div id="address">
			<input type="text" id="addr1" name="<%=Constants.PARAM_ADDRESS1%>" 
					value="<%=patient.getAddressLine1()%>" /> <br />
			<input type="text" id="addr2" name="<%=Constants.PARAM_ADDRESS2%>" 
					value="<%=patient.getAddressLine2()%>" />
		</div>
		<label for="dob">Date of Birth (MM dd yyyy)</label>
		<div id="dob">
			<input type="text" id="month" name="<%=Constants.PARAM_MONTH%>" size="2" maxlength="2"/> 
			<input type="text" id="day" name="<%=Constants.PARAM_DAY%>" size="2" maxlength="2"/> 
			<input type="text" id="year" name="<%=Constants.PARAM_YEAR%>" size="4" maxlength="4"/>
		</div>

		<label for="isMale">Gender</label><br>
		<input type="radio" id="isMale" name="<%=Constants.PARAM_MALE%>" value="true"
			<%if (patient.getIsMale()) out.print("checked=\"checked\""); %>/> Male <br>
		<input type="radio" id="isMale" name="<%=Constants.PARAM_MALE%>" value="false"
			<%if (!patient.getIsMale()) out.print("checked=\"checked\""); %>/> Female <br>
		
		<label for="ethnicity">Ethnicity</label>
		<input type="text" id="ethnicity" name="<%=Constants.PARAM_ETHNICITY%>" 
				value="<%=patient.getEthnicity()%>" />
				
		<fieldset>
		<legend>Emergency Contact</legend>
		<div id="contactName">
			<label for="contact_fname">First Name</label> 
			<input type="text" id="contact_fname" name="<%=Constants.PARAM_CONTACT_FIRST_NAME%>" 
					value="<%=patient.getContactFirstName()%>" /> 
			<label for="contact_lname">Last Name</label> 
			<input type="text" id="contact_lname" name="<%=Constants.PARAM_CONTACT_LAST_NAME%>" 
					value="<%=patient.getContactLastName()%>" />
		</div>
				
		<label for="homePhone">Home Phone</label> 
		<input type="text" id="homePhone" name="<%=Constants.PARAM_CONTACT_PHONE_HOME%>" value="<%=patient.getContactHomePhone()%>" />
		
		<div id="cellPhone">
		<label for="cellPhone">Cell Phone</label>
		<input type="text" id="cellPhoneNumber" name="<%=Constants.PARAM_CONTACT_PHONE_CELL%>" value="<%=patient.getContactCellPhone()%>" /> <br />
		<input type="radio" id="cellCarrier" name="<%=Constants.PARAM_CONTACT_PHONE_CELL_CARRIER%>" value="<%=Constants.CINGULAR%>" 
				<%if (patient.getContactCellCarrier() == (Constants.CINGULAR)) out.print("checked=\"checked\""); %>/> Cingular <br />
		<input type="radio" id="cellCarrier" name="<%=Constants.PARAM_CONTACT_PHONE_CELL_CARRIER%>" value="<%=Constants.SPRINT%>" 
				<%if (patient.getContactCellCarrier() == (Constants.SPRINT)) out.print("checked=\"checked\""); %>/> Sprint <br />
		<input type="radio" id="cellCarrier" name="<%=Constants.PARAM_CONTACT_PHONE_CELL_CARRIER%>" value="<%=Constants.VERIZON%>" 
				<%if (patient.getContactCellCarrier() == (Constants.VERIZON)) out.print("checked=\"checked\""); %>/> Verizon <br />
		<input type="radio" id="cellCarrier" name="<%=Constants.PARAM_CONTACT_PHONE_CELL_CARRIER%>" value="<%=Constants.OTHER%>" 
				<%if (patient.getContactCellCarrier() == (Constants.OTHER)) out.print("checked=\"checked\""); %>/> Other <br />
		</div>
		</fieldset>
		
		<input type="submit" value="Submit"/>
		
		<input type="text" name="<%=Constants.PARAM_ID%>" 
				value="<%=patient.getId()%>" style="visibility: hidden;"/>
		<input type="text" name="<%=Constants.PARAM_ACTION%>"  
				value="<%=Constants.ACTION_EDIT_PATIENT%>" style="visibility: hidden;"/>
		<input type="text" name="url" value="<%=url%>" style="visibility: hidden;"/>
	</form>
</body>
